///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1995/2004 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor : Xilinx
// \   \   \/     Version : 8.1i (I.17)
//  \   \         Description : Xilinx Timing Simulation Library Component
//  /   /                  Ethernet Media Access Controller
// /___/   /\     Filename : X_EMAC.v
// \   \  /  \    Timestamp : Fri Jun 18 10:57:22 PDT 2004
//  \___\/\___\
//
// Revision:
//    03/23/04 - Initial version.
//    08/08/05 - Added missing timing checks.(CR#214079)	
//    12/07/07 - CR 455025 Added delays for 16 bit client mode.	
//    02/04/08 - CR 460680 Changed delay to 125ps.	
//    09/11/08 - Fixed CR#476740. Added 10 ps delay to dcremacclk
// End Revision
`timescale 1 ps / 1 ps 

module X_EMAC (
	DCRHOSTDONEIR,
	EMAC0CLIENTANINTERRUPT,
	EMAC0CLIENTRXBADFRAME,
	EMAC0CLIENTRXCLIENTCLKOUT,
	EMAC0CLIENTRXD,
	EMAC0CLIENTRXDVLD,
	EMAC0CLIENTRXDVLDMSW,
	EMAC0CLIENTRXDVREG6,
	EMAC0CLIENTRXFRAMEDROP,
	EMAC0CLIENTRXGOODFRAME,
	EMAC0CLIENTRXSTATS,
	EMAC0CLIENTRXSTATSBYTEVLD,
	EMAC0CLIENTRXSTATSVLD,
	EMAC0CLIENTTXACK,
	EMAC0CLIENTTXCLIENTCLKOUT,
	EMAC0CLIENTTXCOLLISION,
	EMAC0CLIENTTXGMIIMIICLKOUT,
	EMAC0CLIENTTXRETRANSMIT,
	EMAC0CLIENTTXSTATS,
	EMAC0CLIENTTXSTATSBYTEVLD,
	EMAC0CLIENTTXSTATSVLD,
	EMAC0PHYENCOMMAALIGN,
	EMAC0PHYLOOPBACKMSB,
	EMAC0PHYMCLKOUT,
	EMAC0PHYMDOUT,
	EMAC0PHYMDTRI,
	EMAC0PHYMGTRXRESET,
	EMAC0PHYMGTTXRESET,
	EMAC0PHYPOWERDOWN,
	EMAC0PHYSYNCACQSTATUS,
	EMAC0PHYTXCHARDISPMODE,
	EMAC0PHYTXCHARDISPVAL,
	EMAC0PHYTXCHARISK,
	EMAC0PHYTXCLK,
	EMAC0PHYTXD,
	EMAC0PHYTXEN,
	EMAC0PHYTXER,
	EMAC1CLIENTANINTERRUPT,
	EMAC1CLIENTRXBADFRAME,
	EMAC1CLIENTRXCLIENTCLKOUT,
	EMAC1CLIENTRXD,
	EMAC1CLIENTRXDVLD,
	EMAC1CLIENTRXDVLDMSW,
	EMAC1CLIENTRXDVREG6,
	EMAC1CLIENTRXFRAMEDROP,
	EMAC1CLIENTRXGOODFRAME,
	EMAC1CLIENTRXSTATS,
	EMAC1CLIENTRXSTATSBYTEVLD,
	EMAC1CLIENTRXSTATSVLD,
	EMAC1CLIENTTXACK,
	EMAC1CLIENTTXCLIENTCLKOUT,
	EMAC1CLIENTTXCOLLISION,
	EMAC1CLIENTTXGMIIMIICLKOUT,
	EMAC1CLIENTTXRETRANSMIT,
	EMAC1CLIENTTXSTATS,
	EMAC1CLIENTTXSTATSBYTEVLD,
	EMAC1CLIENTTXSTATSVLD,
	EMAC1PHYENCOMMAALIGN,
	EMAC1PHYLOOPBACKMSB,
	EMAC1PHYMCLKOUT,
	EMAC1PHYMDOUT,
	EMAC1PHYMDTRI,
	EMAC1PHYMGTRXRESET,
	EMAC1PHYMGTTXRESET,
	EMAC1PHYPOWERDOWN,
	EMAC1PHYSYNCACQSTATUS,
	EMAC1PHYTXCHARDISPMODE,
	EMAC1PHYTXCHARDISPVAL,
	EMAC1PHYTXCHARISK,
	EMAC1PHYTXCLK,
	EMAC1PHYTXD,
	EMAC1PHYTXEN,
	EMAC1PHYTXER,
	EMACDCRACK,
	EMACDCRDBUS,
	HOSTMIIMRDY,
	HOSTRDDATA,
	CLIENTEMAC0DCMLOCKED,
	CLIENTEMAC0PAUSEREQ,
	CLIENTEMAC0PAUSEVAL,
	CLIENTEMAC0RXCLIENTCLKIN,
	CLIENTEMAC0TXCLIENTCLKIN,
	CLIENTEMAC0TXD,
	CLIENTEMAC0TXDVLD,
	CLIENTEMAC0TXDVLDMSW,
	CLIENTEMAC0TXFIRSTBYTE,
	CLIENTEMAC0TXGMIIMIICLKIN,
	CLIENTEMAC0TXIFGDELAY,
	CLIENTEMAC0TXUNDERRUN,
	CLIENTEMAC1DCMLOCKED,
	CLIENTEMAC1PAUSEREQ,
	CLIENTEMAC1PAUSEVAL,
	CLIENTEMAC1RXCLIENTCLKIN,
	CLIENTEMAC1TXCLIENTCLKIN,
	CLIENTEMAC1TXD,
	CLIENTEMAC1TXDVLD,
	CLIENTEMAC1TXDVLDMSW,
	CLIENTEMAC1TXFIRSTBYTE,
	CLIENTEMAC1TXGMIIMIICLKIN,
	CLIENTEMAC1TXIFGDELAY,
	CLIENTEMAC1TXUNDERRUN,
	DCREMACABUS,
	DCREMACCLK,
	DCREMACDBUS,
	DCREMACENABLE,
	DCREMACREAD,
	DCREMACWRITE,
	HOSTADDR,
	HOSTCLK,
	HOSTEMAC1SEL,
	HOSTMIIMSEL,
	HOSTOPCODE,
	HOSTREQ,
	HOSTWRDATA,
	PHYEMAC0COL,
	PHYEMAC0CRS,
	PHYEMAC0GTXCLK,
	PHYEMAC0MCLKIN,
	PHYEMAC0MDIN,
	PHYEMAC0MIITXCLK,
	PHYEMAC0PHYAD,
	PHYEMAC0RXBUFERR,
	PHYEMAC0RXBUFSTATUS,
	PHYEMAC0RXCHARISCOMMA,
	PHYEMAC0RXCHARISK,
	PHYEMAC0RXCHECKINGCRC,
	PHYEMAC0RXCLK,
	PHYEMAC0RXCLKCORCNT,
	PHYEMAC0RXCOMMADET,
	PHYEMAC0RXD,
	PHYEMAC0RXDISPERR,
	PHYEMAC0RXDV,
	PHYEMAC0RXER,
	PHYEMAC0RXLOSSOFSYNC,
	PHYEMAC0RXNOTINTABLE,
	PHYEMAC0RXRUNDISP,
	PHYEMAC0SIGNALDET,
	PHYEMAC0TXBUFERR,
	PHYEMAC1COL,
	PHYEMAC1CRS,
	PHYEMAC1GTXCLK,
	PHYEMAC1MCLKIN,
	PHYEMAC1MDIN,
	PHYEMAC1MIITXCLK,
	PHYEMAC1PHYAD,
	PHYEMAC1RXBUFERR,
	PHYEMAC1RXBUFSTATUS,
	PHYEMAC1RXCHARISCOMMA,
	PHYEMAC1RXCHARISK,
	PHYEMAC1RXCHECKINGCRC,
	PHYEMAC1RXCLK,
	PHYEMAC1RXCLKCORCNT,
	PHYEMAC1RXCOMMADET,
	PHYEMAC1RXD,
	PHYEMAC1RXDISPERR,
	PHYEMAC1RXDV,
	PHYEMAC1RXER,
	PHYEMAC1RXLOSSOFSYNC,
	PHYEMAC1RXNOTINTABLE,
	PHYEMAC1RXRUNDISP,
	PHYEMAC1SIGNALDET,
	PHYEMAC1TXBUFERR,
	RESET,
	TIEEMAC0CONFIGVEC,
	TIEEMAC0UNICASTADDR,
	TIEEMAC1CONFIGVEC,
	TIEEMAC1UNICASTADDR
);

parameter LOC = "UNPLACED";

output DCRHOSTDONEIR;
output EMAC0CLIENTANINTERRUPT;
output EMAC0CLIENTRXBADFRAME;
output EMAC0CLIENTRXCLIENTCLKOUT;
output EMAC0CLIENTRXDVLD;
output EMAC0CLIENTRXDVLDMSW;
output EMAC0CLIENTRXDVREG6;
output EMAC0CLIENTRXFRAMEDROP;
output EMAC0CLIENTRXGOODFRAME;
output EMAC0CLIENTRXSTATSBYTEVLD;
output EMAC0CLIENTRXSTATSVLD;
output EMAC0CLIENTTXACK;
output EMAC0CLIENTTXCLIENTCLKOUT;
output EMAC0CLIENTTXCOLLISION;
output EMAC0CLIENTTXGMIIMIICLKOUT;
output EMAC0CLIENTTXRETRANSMIT;
output EMAC0CLIENTTXSTATS;
output EMAC0CLIENTTXSTATSBYTEVLD;
output EMAC0CLIENTTXSTATSVLD;
output EMAC0PHYENCOMMAALIGN;
output EMAC0PHYLOOPBACKMSB;
output EMAC0PHYMCLKOUT;
output EMAC0PHYMDOUT;
output EMAC0PHYMDTRI;
output EMAC0PHYMGTRXRESET;
output EMAC0PHYMGTTXRESET;
output EMAC0PHYPOWERDOWN;
output EMAC0PHYSYNCACQSTATUS;
output EMAC0PHYTXCHARDISPMODE;
output EMAC0PHYTXCHARDISPVAL;
output EMAC0PHYTXCHARISK;
output EMAC0PHYTXCLK;
output EMAC0PHYTXEN;
output EMAC0PHYTXER;
output EMAC1CLIENTANINTERRUPT;
output EMAC1CLIENTRXBADFRAME;
output EMAC1CLIENTRXCLIENTCLKOUT;
output EMAC1CLIENTRXDVLD;
output EMAC1CLIENTRXDVLDMSW;
output EMAC1CLIENTRXDVREG6;
output EMAC1CLIENTRXFRAMEDROP;
output EMAC1CLIENTRXGOODFRAME;
output EMAC1CLIENTRXSTATSBYTEVLD;
output EMAC1CLIENTRXSTATSVLD;
output EMAC1CLIENTTXACK;
output EMAC1CLIENTTXCLIENTCLKOUT;
output EMAC1CLIENTTXCOLLISION;
output EMAC1CLIENTTXGMIIMIICLKOUT;
output EMAC1CLIENTTXRETRANSMIT;
output EMAC1CLIENTTXSTATS;
output EMAC1CLIENTTXSTATSBYTEVLD;
output EMAC1CLIENTTXSTATSVLD;
output EMAC1PHYENCOMMAALIGN;
output EMAC1PHYLOOPBACKMSB;
output EMAC1PHYMCLKOUT;
output EMAC1PHYMDOUT;
output EMAC1PHYMDTRI;
output EMAC1PHYMGTRXRESET;
output EMAC1PHYMGTTXRESET;
output EMAC1PHYPOWERDOWN;
output EMAC1PHYSYNCACQSTATUS;
output EMAC1PHYTXCHARDISPMODE;
output EMAC1PHYTXCHARDISPVAL;
output EMAC1PHYTXCHARISK;
output EMAC1PHYTXCLK;
output EMAC1PHYTXEN;
output EMAC1PHYTXER;
output EMACDCRACK;
output HOSTMIIMRDY;
output [0:31] EMACDCRDBUS;
output [15:0] EMAC0CLIENTRXD;
output [15:0] EMAC1CLIENTRXD;
output [31:0] HOSTRDDATA;
output [6:0] EMAC0CLIENTRXSTATS;
output [6:0] EMAC1CLIENTRXSTATS;
output [7:0] EMAC0PHYTXD;
output [7:0] EMAC1PHYTXD;

input CLIENTEMAC0DCMLOCKED;
input CLIENTEMAC0PAUSEREQ;
input CLIENTEMAC0RXCLIENTCLKIN;
input CLIENTEMAC0TXCLIENTCLKIN;
input CLIENTEMAC0TXDVLD;
input CLIENTEMAC0TXDVLDMSW;
input CLIENTEMAC0TXFIRSTBYTE;
input CLIENTEMAC0TXGMIIMIICLKIN;
input CLIENTEMAC0TXUNDERRUN;
input CLIENTEMAC1DCMLOCKED;
input CLIENTEMAC1PAUSEREQ;
input CLIENTEMAC1RXCLIENTCLKIN;
input CLIENTEMAC1TXCLIENTCLKIN;
input CLIENTEMAC1TXDVLD;
input CLIENTEMAC1TXDVLDMSW;
input CLIENTEMAC1TXFIRSTBYTE;
input CLIENTEMAC1TXGMIIMIICLKIN;
input CLIENTEMAC1TXUNDERRUN;
input DCREMACCLK;
input DCREMACENABLE;
input DCREMACREAD;
input DCREMACWRITE;
input HOSTCLK;
input HOSTEMAC1SEL;
input HOSTMIIMSEL;
input HOSTREQ;
input PHYEMAC0COL;
input PHYEMAC0CRS;
input PHYEMAC0GTXCLK;
input PHYEMAC0MCLKIN;
input PHYEMAC0MDIN;
input PHYEMAC0MIITXCLK;
input PHYEMAC0RXBUFERR;
input PHYEMAC0RXCHARISCOMMA;
input PHYEMAC0RXCHARISK;
input PHYEMAC0RXCHECKINGCRC;
input PHYEMAC0RXCLK;
input PHYEMAC0RXCOMMADET;
input PHYEMAC0RXDISPERR;
input PHYEMAC0RXDV;
input PHYEMAC0RXER;
input PHYEMAC0RXNOTINTABLE;
input PHYEMAC0RXRUNDISP;
input PHYEMAC0SIGNALDET;
input PHYEMAC0TXBUFERR;
input PHYEMAC1COL;
input PHYEMAC1CRS;
input PHYEMAC1GTXCLK;
input PHYEMAC1MCLKIN;
input PHYEMAC1MDIN;
input PHYEMAC1MIITXCLK;
input PHYEMAC1RXBUFERR;
input PHYEMAC1RXCHARISCOMMA;
input PHYEMAC1RXCHARISK;
input PHYEMAC1RXCHECKINGCRC;
input PHYEMAC1RXCLK;
input PHYEMAC1RXCOMMADET;
input PHYEMAC1RXDISPERR;
input PHYEMAC1RXDV;
input PHYEMAC1RXER;
input PHYEMAC1RXNOTINTABLE;
input PHYEMAC1RXRUNDISP;
input PHYEMAC1SIGNALDET;
input PHYEMAC1TXBUFERR;
input RESET;
input [0:31] DCREMACDBUS;
input [15:0] CLIENTEMAC0PAUSEVAL;
input [15:0] CLIENTEMAC0TXD;
input [15:0] CLIENTEMAC1PAUSEVAL;
input [15:0] CLIENTEMAC1TXD;
input [1:0] HOSTOPCODE;
input [1:0] PHYEMAC0RXBUFSTATUS;
input [1:0] PHYEMAC0RXLOSSOFSYNC;
input [1:0] PHYEMAC1RXBUFSTATUS;
input [1:0] PHYEMAC1RXLOSSOFSYNC;
input [2:0] PHYEMAC0RXCLKCORCNT;
input [2:0] PHYEMAC1RXCLKCORCNT;
input [31:0] HOSTWRDATA;
input [47:0] TIEEMAC0UNICASTADDR;
input [47:0] TIEEMAC1UNICASTADDR;
input [4:0] PHYEMAC0PHYAD;
input [4:0] PHYEMAC1PHYAD;
input [79:0] TIEEMAC0CONFIGVEC;
input [79:0] TIEEMAC1CONFIGVEC;
input [7:0] CLIENTEMAC0TXIFGDELAY;
input [7:0] CLIENTEMAC1TXIFGDELAY;
input [7:0] PHYEMAC0RXD;
input [7:0] PHYEMAC1RXD;
input [8:9] DCREMACABUS;
input [9:0] HOSTADDR;


reg notifier;

wire CLIENTEMAC0DCMLOCKED_IN;
wire CLIENTEMAC0PAUSEREQ_IN;
wire CLIENTEMAC0RXCLIENTCLKIN_IN;
wire CLIENTEMAC0TXCLIENTCLKIN_IN;
wire CLIENTEMAC0TXDVLDMSW_IN;
wire CLIENTEMAC0TXDVLD_IN;
wire CLIENTEMAC0TXFIRSTBYTE_IN;
wire CLIENTEMAC0TXGMIIMIICLKIN_IN;
wire CLIENTEMAC0TXUNDERRUN_IN;
wire CLIENTEMAC1DCMLOCKED_IN;
wire CLIENTEMAC1PAUSEREQ_IN;
wire CLIENTEMAC1RXCLIENTCLKIN_IN;
wire CLIENTEMAC1TXCLIENTCLKIN_IN;
wire CLIENTEMAC1TXDVLDMSW_IN;
wire CLIENTEMAC1TXDVLD_IN;
wire CLIENTEMAC1TXFIRSTBYTE_IN;
wire CLIENTEMAC1TXGMIIMIICLKIN_IN;
wire CLIENTEMAC1TXUNDERRUN_IN;
wire DCREMACCLK_IN;
wire DCREMACENABLE_IN;
wire DCREMACREAD_IN;
wire DCREMACWRITE_IN;
wire DCRHOSTDONEIR_OUT;
wire EMAC0CLIENTANINTERRUPT_OUT;
wire EMAC0CLIENTRXBADFRAME_OUT;
wire EMAC0CLIENTRXCLIENTCLKOUT_OUT;
wire EMAC0CLIENTRXDVLDMSW_OUT;
wire EMAC0CLIENTRXDVLD_OUT;
wire EMAC0CLIENTRXDVREG6_OUT;
wire EMAC0CLIENTRXFRAMEDROP_OUT;
wire EMAC0CLIENTRXGOODFRAME_OUT;
wire EMAC0CLIENTRXSTATSBYTEVLD_OUT;
wire EMAC0CLIENTRXSTATSVLD_OUT;
wire EMAC0CLIENTTXACK_OUT;
wire EMAC0CLIENTTXCLIENTCLKOUT_OUT;
wire EMAC0CLIENTTXCOLLISION_OUT;
wire EMAC0CLIENTTXGMIIMIICLKOUT_OUT;
wire EMAC0CLIENTTXRETRANSMIT_OUT;
wire EMAC0CLIENTTXSTATSBYTEVLD_OUT;
wire EMAC0CLIENTTXSTATSVLD_OUT;
wire EMAC0CLIENTTXSTATS_OUT;
wire EMAC0PHYENCOMMAALIGN_OUT;
wire EMAC0PHYLOOPBACKMSB_OUT;
wire EMAC0PHYMCLKOUT_OUT;
wire EMAC0PHYMDOUT_OUT;
wire EMAC0PHYMDTRI_OUT;
wire EMAC0PHYMGTRXRESET_OUT;
wire EMAC0PHYMGTTXRESET_OUT;
wire EMAC0PHYPOWERDOWN_OUT;
wire EMAC0PHYSYNCACQSTATUS_OUT;
wire EMAC0PHYTXCHARDISPMODE_OUT;
wire EMAC0PHYTXCHARDISPVAL_OUT;
wire EMAC0PHYTXCHARISK_OUT;
wire EMAC0PHYTXCLK_OUT;
wire EMAC0PHYTXEN_OUT;
wire EMAC0PHYTXER_OUT;
wire EMAC1CLIENTANINTERRUPT_OUT;
wire EMAC1CLIENTRXBADFRAME_OUT;
wire EMAC1CLIENTRXCLIENTCLKOUT_OUT;
wire EMAC1CLIENTRXDVLDMSW_OUT;
wire EMAC1CLIENTRXDVLD_OUT;
wire EMAC1CLIENTRXDVREG6_OUT;
wire EMAC1CLIENTRXFRAMEDROP_OUT;
wire EMAC1CLIENTRXGOODFRAME_OUT;
wire EMAC1CLIENTRXSTATSBYTEVLD_OUT;
wire EMAC1CLIENTRXSTATSVLD_OUT;
wire EMAC1CLIENTTXACK_OUT;
wire EMAC1CLIENTTXCLIENTCLKOUT_OUT;
wire EMAC1CLIENTTXCOLLISION_OUT;
wire EMAC1CLIENTTXGMIIMIICLKOUT_OUT;
wire EMAC1CLIENTTXRETRANSMIT_OUT;
wire EMAC1CLIENTTXSTATSBYTEVLD_OUT;
wire EMAC1CLIENTTXSTATSVLD_OUT;
wire EMAC1CLIENTTXSTATS_OUT;
wire EMAC1PHYENCOMMAALIGN_OUT;
wire EMAC1PHYLOOPBACKMSB_OUT;
wire EMAC1PHYMCLKOUT_OUT;
wire EMAC1PHYMDOUT_OUT;
wire EMAC1PHYMDTRI_OUT;
wire EMAC1PHYMGTRXRESET_OUT;
wire EMAC1PHYMGTTXRESET_OUT;
wire EMAC1PHYPOWERDOWN_OUT;
wire EMAC1PHYSYNCACQSTATUS_OUT;
wire EMAC1PHYTXCHARDISPMODE_OUT;
wire EMAC1PHYTXCHARDISPVAL_OUT;
wire EMAC1PHYTXCHARISK_OUT;
wire EMAC1PHYTXCLK_OUT;
wire EMAC1PHYTXEN_OUT;
wire EMAC1PHYTXER_OUT;
wire EMACDCRACK_OUT;
wire HOSTCLK_IN;
wire HOSTEMAC1SEL_IN;
wire HOSTMIIMRDY_OUT;
wire HOSTMIIMSEL_IN;
wire HOSTREQ_IN;
wire PHYEMAC0COL_IN;
wire PHYEMAC0CRS_IN;
wire PHYEMAC0GTXCLK_IN;
wire PHYEMAC0MCLKIN_IN;
wire PHYEMAC0MDIN_IN;
wire PHYEMAC0MIITXCLK_IN;
wire PHYEMAC0RXBUFERR_IN;
wire PHYEMAC0RXCHARISCOMMA_IN;
wire PHYEMAC0RXCHARISK_IN;
wire PHYEMAC0RXCHECKINGCRC_IN;
wire PHYEMAC0RXCLK_IN;
wire PHYEMAC0RXCOMMADET_IN;
wire PHYEMAC0RXDISPERR_IN;
wire PHYEMAC0RXDV_IN;
wire PHYEMAC0RXER_IN;
wire PHYEMAC0RXNOTINTABLE_IN;
wire PHYEMAC0RXRUNDISP_IN;
wire PHYEMAC0SIGNALDET_IN;
wire PHYEMAC0TXBUFERR_IN;
wire PHYEMAC1COL_IN;
wire PHYEMAC1CRS_IN;
wire PHYEMAC1GTXCLK_IN;
wire PHYEMAC1MCLKIN_IN;
wire PHYEMAC1MDIN_IN;
wire PHYEMAC1MIITXCLK_IN;
wire PHYEMAC1RXBUFERR_IN;
wire PHYEMAC1RXCHARISCOMMA_IN;
wire PHYEMAC1RXCHARISK_IN;
wire PHYEMAC1RXCHECKINGCRC_IN;
wire PHYEMAC1RXCLK_IN;
wire PHYEMAC1RXCOMMADET_IN;
wire PHYEMAC1RXDISPERR_IN;
wire PHYEMAC1RXDV_IN;
wire PHYEMAC1RXER_IN;
wire PHYEMAC1RXNOTINTABLE_IN;
wire PHYEMAC1RXRUNDISP_IN;
wire PHYEMAC1SIGNALDET_IN;
wire PHYEMAC1TXBUFERR_IN;
wire RESET_IN;
wire [0:31] DCREMACDBUS_IN;
wire [0:31] EMACDCRDBUS_OUT;
wire [15:0] CLIENTEMAC0PAUSEVAL_IN;
wire [15:0] CLIENTEMAC0TXD_IN;
wire [15:0] CLIENTEMAC1PAUSEVAL_IN;
wire [15:0] CLIENTEMAC1TXD_IN;
wire [15:0] EMAC0CLIENTRXD_OUT;
wire [15:0] EMAC1CLIENTRXD_OUT;
wire [1:0] HOSTOPCODE_IN;
wire [1:0] PHYEMAC0RXBUFSTATUS_IN;
wire [1:0] PHYEMAC0RXLOSSOFSYNC_IN;
wire [1:0] PHYEMAC1RXBUFSTATUS_IN;
wire [1:0] PHYEMAC1RXLOSSOFSYNC_IN;
wire [2:0] PHYEMAC0RXCLKCORCNT_IN;
wire [2:0] PHYEMAC1RXCLKCORCNT_IN;
wire [31:0] HOSTRDDATA_OUT;
wire [31:0] HOSTWRDATA_IN;
wire [47:0] TIEEMAC0UNICASTADDR_IN;
wire [47:0] TIEEMAC1UNICASTADDR_IN;
wire [4:0] PHYEMAC0PHYAD_IN;
wire [4:0] PHYEMAC1PHYAD_IN;
wire [6:0] EMAC0CLIENTRXSTATS_OUT;
wire [6:0] EMAC1CLIENTRXSTATS_OUT;
wire [79:0] TIEEMAC0CONFIGVEC_IN;
wire [79:0] TIEEMAC1CONFIGVEC_IN;
wire [7:0] CLIENTEMAC0TXIFGDELAY_IN;
wire [7:0] CLIENTEMAC1TXIFGDELAY_IN;
wire [7:0] EMAC0PHYTXD_OUT;
wire [7:0] EMAC1PHYTXD_OUT;
wire [7:0] PHYEMAC0RXD_IN;
wire [7:0] PHYEMAC1RXD_IN;
wire [8:9] DCREMACABUS_IN;
wire [9:0] HOSTADDR_IN;

// Delay wrapper for 16-bit client mode
wire PHYEMAC0MIITXCLK_delay;
wire [15:0] CLIENTEMAC0TXD_delay;
wire CLIENTEMAC0TXDVLD_delay;
wire CLIENTEMAC0TXDVLDMSW_delay;
wire PHYEMAC0MIITXCLK_skewed;
wire [15:0] CLIENTEMAC0TXD_client16_delay;
wire CLIENTEMAC0TXDVLD_client16_delay;
wire CLIENTEMAC0TXDVLDMSW_client16_delay;

wire PHYEMAC1MIITXCLK_delay;
wire [15:0] CLIENTEMAC1TXD_delay;
wire CLIENTEMAC1TXDVLD_delay;
wire CLIENTEMAC1TXDVLDMSW_delay;
wire PHYEMAC1MIITXCLK_skewed;
wire [15:0] CLIENTEMAC1TXD_client16_delay;
wire CLIENTEMAC1TXDVLD_client16_delay;
wire CLIENTEMAC1TXDVLDMSW_client16_delay;

initial begin
end

buf B_DCRHOSTDONEIR (DCRHOSTDONEIR, DCRHOSTDONEIR_OUT);
buf B_EMAC0CLIENTANINTERRUPT (EMAC0CLIENTANINTERRUPT, EMAC0CLIENTANINTERRUPT_OUT);
buf B_EMAC0CLIENTRXBADFRAME (EMAC0CLIENTRXBADFRAME, EMAC0CLIENTRXBADFRAME_OUT);
buf B_EMAC0CLIENTRXCLIENTCLKOUT (EMAC0CLIENTRXCLIENTCLKOUT, EMAC0CLIENTRXCLIENTCLKOUT_OUT);
buf B_EMAC0CLIENTRXD0 (EMAC0CLIENTRXD[0], EMAC0CLIENTRXD_OUT[0]);
buf B_EMAC0CLIENTRXD1 (EMAC0CLIENTRXD[1], EMAC0CLIENTRXD_OUT[1]);
buf B_EMAC0CLIENTRXD2 (EMAC0CLIENTRXD[2], EMAC0CLIENTRXD_OUT[2]);
buf B_EMAC0CLIENTRXD3 (EMAC0CLIENTRXD[3], EMAC0CLIENTRXD_OUT[3]);
buf B_EMAC0CLIENTRXD4 (EMAC0CLIENTRXD[4], EMAC0CLIENTRXD_OUT[4]);
buf B_EMAC0CLIENTRXD5 (EMAC0CLIENTRXD[5], EMAC0CLIENTRXD_OUT[5]);
buf B_EMAC0CLIENTRXD6 (EMAC0CLIENTRXD[6], EMAC0CLIENTRXD_OUT[6]);
buf B_EMAC0CLIENTRXD7 (EMAC0CLIENTRXD[7], EMAC0CLIENTRXD_OUT[7]);
buf B_EMAC0CLIENTRXD8 (EMAC0CLIENTRXD[8], EMAC0CLIENTRXD_OUT[8]);
buf B_EMAC0CLIENTRXD9 (EMAC0CLIENTRXD[9], EMAC0CLIENTRXD_OUT[9]);
buf B_EMAC0CLIENTRXD10 (EMAC0CLIENTRXD[10], EMAC0CLIENTRXD_OUT[10]);
buf B_EMAC0CLIENTRXD11 (EMAC0CLIENTRXD[11], EMAC0CLIENTRXD_OUT[11]);
buf B_EMAC0CLIENTRXD12 (EMAC0CLIENTRXD[12], EMAC0CLIENTRXD_OUT[12]);
buf B_EMAC0CLIENTRXD13 (EMAC0CLIENTRXD[13], EMAC0CLIENTRXD_OUT[13]);
buf B_EMAC0CLIENTRXD14 (EMAC0CLIENTRXD[14], EMAC0CLIENTRXD_OUT[14]);
buf B_EMAC0CLIENTRXD15 (EMAC0CLIENTRXD[15], EMAC0CLIENTRXD_OUT[15]);
buf B_EMAC0CLIENTRXDVLD (EMAC0CLIENTRXDVLD, EMAC0CLIENTRXDVLD_OUT);
buf B_EMAC0CLIENTRXDVLDMSW (EMAC0CLIENTRXDVLDMSW, EMAC0CLIENTRXDVLDMSW_OUT);
buf B_EMAC0CLIENTRXDVREG6 (EMAC0CLIENTRXDVREG6, EMAC0CLIENTRXDVREG6_OUT);
buf B_EMAC0CLIENTRXFRAMEDROP (EMAC0CLIENTRXFRAMEDROP, EMAC0CLIENTRXFRAMEDROP_OUT);
buf B_EMAC0CLIENTRXGOODFRAME (EMAC0CLIENTRXGOODFRAME, EMAC0CLIENTRXGOODFRAME_OUT);
buf B_EMAC0CLIENTRXSTATS0 (EMAC0CLIENTRXSTATS[0], EMAC0CLIENTRXSTATS_OUT[0]);
buf B_EMAC0CLIENTRXSTATS1 (EMAC0CLIENTRXSTATS[1], EMAC0CLIENTRXSTATS_OUT[1]);
buf B_EMAC0CLIENTRXSTATS2 (EMAC0CLIENTRXSTATS[2], EMAC0CLIENTRXSTATS_OUT[2]);
buf B_EMAC0CLIENTRXSTATS3 (EMAC0CLIENTRXSTATS[3], EMAC0CLIENTRXSTATS_OUT[3]);
buf B_EMAC0CLIENTRXSTATS4 (EMAC0CLIENTRXSTATS[4], EMAC0CLIENTRXSTATS_OUT[4]);
buf B_EMAC0CLIENTRXSTATS5 (EMAC0CLIENTRXSTATS[5], EMAC0CLIENTRXSTATS_OUT[5]);
buf B_EMAC0CLIENTRXSTATS6 (EMAC0CLIENTRXSTATS[6], EMAC0CLIENTRXSTATS_OUT[6]);
buf B_EMAC0CLIENTRXSTATSBYTEVLD (EMAC0CLIENTRXSTATSBYTEVLD, EMAC0CLIENTRXSTATSBYTEVLD_OUT);
buf B_EMAC0CLIENTRXSTATSVLD (EMAC0CLIENTRXSTATSVLD, EMAC0CLIENTRXSTATSVLD_OUT);
buf B_EMAC0CLIENTTXACK (EMAC0CLIENTTXACK, EMAC0CLIENTTXACK_OUT);
buf B_EMAC0CLIENTTXCLIENTCLKOUT (EMAC0CLIENTTXCLIENTCLKOUT, EMAC0CLIENTTXCLIENTCLKOUT_OUT);
buf B_EMAC0CLIENTTXCOLLISION (EMAC0CLIENTTXCOLLISION, EMAC0CLIENTTXCOLLISION_OUT);
buf B_EMAC0CLIENTTXGMIIMIICLKOUT (EMAC0CLIENTTXGMIIMIICLKOUT, EMAC0CLIENTTXGMIIMIICLKOUT_OUT);
buf B_EMAC0CLIENTTXRETRANSMIT (EMAC0CLIENTTXRETRANSMIT, EMAC0CLIENTTXRETRANSMIT_OUT);
buf B_EMAC0CLIENTTXSTATS (EMAC0CLIENTTXSTATS, EMAC0CLIENTTXSTATS_OUT);
buf B_EMAC0CLIENTTXSTATSBYTEVLD (EMAC0CLIENTTXSTATSBYTEVLD, EMAC0CLIENTTXSTATSBYTEVLD_OUT);
buf B_EMAC0CLIENTTXSTATSVLD (EMAC0CLIENTTXSTATSVLD, EMAC0CLIENTTXSTATSVLD_OUT);
buf B_EMAC0PHYENCOMMAALIGN (EMAC0PHYENCOMMAALIGN, EMAC0PHYENCOMMAALIGN_OUT);
buf B_EMAC0PHYLOOPBACKMSB (EMAC0PHYLOOPBACKMSB, EMAC0PHYLOOPBACKMSB_OUT);
buf B_EMAC0PHYMCLKOUT (EMAC0PHYMCLKOUT, EMAC0PHYMCLKOUT_OUT);
buf B_EMAC0PHYMDOUT (EMAC0PHYMDOUT, EMAC0PHYMDOUT_OUT);
buf B_EMAC0PHYMDTRI (EMAC0PHYMDTRI, EMAC0PHYMDTRI_OUT);
buf B_EMAC0PHYMGTRXRESET (EMAC0PHYMGTRXRESET, EMAC0PHYMGTRXRESET_OUT);
buf B_EMAC0PHYMGTTXRESET (EMAC0PHYMGTTXRESET, EMAC0PHYMGTTXRESET_OUT);
buf B_EMAC0PHYPOWERDOWN (EMAC0PHYPOWERDOWN, EMAC0PHYPOWERDOWN_OUT);
buf B_EMAC0PHYSYNCACQSTATUS (EMAC0PHYSYNCACQSTATUS, EMAC0PHYSYNCACQSTATUS_OUT);
buf B_EMAC0PHYTXCHARDISPMODE (EMAC0PHYTXCHARDISPMODE, EMAC0PHYTXCHARDISPMODE_OUT);
buf B_EMAC0PHYTXCHARDISPVAL (EMAC0PHYTXCHARDISPVAL, EMAC0PHYTXCHARDISPVAL_OUT);
buf B_EMAC0PHYTXCHARISK (EMAC0PHYTXCHARISK, EMAC0PHYTXCHARISK_OUT);
buf B_EMAC0PHYTXCLK (EMAC0PHYTXCLK, EMAC0PHYTXCLK_OUT);
buf B_EMAC0PHYTXD0 (EMAC0PHYTXD[0], EMAC0PHYTXD_OUT[0]);
buf B_EMAC0PHYTXD1 (EMAC0PHYTXD[1], EMAC0PHYTXD_OUT[1]);
buf B_EMAC0PHYTXD2 (EMAC0PHYTXD[2], EMAC0PHYTXD_OUT[2]);
buf B_EMAC0PHYTXD3 (EMAC0PHYTXD[3], EMAC0PHYTXD_OUT[3]);
buf B_EMAC0PHYTXD4 (EMAC0PHYTXD[4], EMAC0PHYTXD_OUT[4]);
buf B_EMAC0PHYTXD5 (EMAC0PHYTXD[5], EMAC0PHYTXD_OUT[5]);
buf B_EMAC0PHYTXD6 (EMAC0PHYTXD[6], EMAC0PHYTXD_OUT[6]);
buf B_EMAC0PHYTXD7 (EMAC0PHYTXD[7], EMAC0PHYTXD_OUT[7]);
buf B_EMAC0PHYTXEN (EMAC0PHYTXEN, EMAC0PHYTXEN_OUT);
buf B_EMAC0PHYTXER (EMAC0PHYTXER, EMAC0PHYTXER_OUT);
buf B_EMAC1CLIENTANINTERRUPT (EMAC1CLIENTANINTERRUPT, EMAC1CLIENTANINTERRUPT_OUT);
buf B_EMAC1CLIENTRXBADFRAME (EMAC1CLIENTRXBADFRAME, EMAC1CLIENTRXBADFRAME_OUT);
buf B_EMAC1CLIENTRXCLIENTCLKOUT (EMAC1CLIENTRXCLIENTCLKOUT, EMAC1CLIENTRXCLIENTCLKOUT_OUT);
buf B_EMAC1CLIENTRXD0 (EMAC1CLIENTRXD[0], EMAC1CLIENTRXD_OUT[0]);
buf B_EMAC1CLIENTRXD1 (EMAC1CLIENTRXD[1], EMAC1CLIENTRXD_OUT[1]);
buf B_EMAC1CLIENTRXD2 (EMAC1CLIENTRXD[2], EMAC1CLIENTRXD_OUT[2]);
buf B_EMAC1CLIENTRXD3 (EMAC1CLIENTRXD[3], EMAC1CLIENTRXD_OUT[3]);
buf B_EMAC1CLIENTRXD4 (EMAC1CLIENTRXD[4], EMAC1CLIENTRXD_OUT[4]);
buf B_EMAC1CLIENTRXD5 (EMAC1CLIENTRXD[5], EMAC1CLIENTRXD_OUT[5]);
buf B_EMAC1CLIENTRXD6 (EMAC1CLIENTRXD[6], EMAC1CLIENTRXD_OUT[6]);
buf B_EMAC1CLIENTRXD7 (EMAC1CLIENTRXD[7], EMAC1CLIENTRXD_OUT[7]);
buf B_EMAC1CLIENTRXD8 (EMAC1CLIENTRXD[8], EMAC1CLIENTRXD_OUT[8]);
buf B_EMAC1CLIENTRXD9 (EMAC1CLIENTRXD[9], EMAC1CLIENTRXD_OUT[9]);
buf B_EMAC1CLIENTRXD10 (EMAC1CLIENTRXD[10], EMAC1CLIENTRXD_OUT[10]);
buf B_EMAC1CLIENTRXD11 (EMAC1CLIENTRXD[11], EMAC1CLIENTRXD_OUT[11]);
buf B_EMAC1CLIENTRXD12 (EMAC1CLIENTRXD[12], EMAC1CLIENTRXD_OUT[12]);
buf B_EMAC1CLIENTRXD13 (EMAC1CLIENTRXD[13], EMAC1CLIENTRXD_OUT[13]);
buf B_EMAC1CLIENTRXD14 (EMAC1CLIENTRXD[14], EMAC1CLIENTRXD_OUT[14]);
buf B_EMAC1CLIENTRXD15 (EMAC1CLIENTRXD[15], EMAC1CLIENTRXD_OUT[15]);
buf B_EMAC1CLIENTRXDVLD (EMAC1CLIENTRXDVLD, EMAC1CLIENTRXDVLD_OUT);
buf B_EMAC1CLIENTRXDVLDMSW (EMAC1CLIENTRXDVLDMSW, EMAC1CLIENTRXDVLDMSW_OUT);
buf B_EMAC1CLIENTRXDVREG6 (EMAC1CLIENTRXDVREG6, EMAC1CLIENTRXDVREG6_OUT);
buf B_EMAC1CLIENTRXFRAMEDROP (EMAC1CLIENTRXFRAMEDROP, EMAC1CLIENTRXFRAMEDROP_OUT);
buf B_EMAC1CLIENTRXGOODFRAME (EMAC1CLIENTRXGOODFRAME, EMAC1CLIENTRXGOODFRAME_OUT);
buf B_EMAC1CLIENTRXSTATS0 (EMAC1CLIENTRXSTATS[0], EMAC1CLIENTRXSTATS_OUT[0]);
buf B_EMAC1CLIENTRXSTATS1 (EMAC1CLIENTRXSTATS[1], EMAC1CLIENTRXSTATS_OUT[1]);
buf B_EMAC1CLIENTRXSTATS2 (EMAC1CLIENTRXSTATS[2], EMAC1CLIENTRXSTATS_OUT[2]);
buf B_EMAC1CLIENTRXSTATS3 (EMAC1CLIENTRXSTATS[3], EMAC1CLIENTRXSTATS_OUT[3]);
buf B_EMAC1CLIENTRXSTATS4 (EMAC1CLIENTRXSTATS[4], EMAC1CLIENTRXSTATS_OUT[4]);
buf B_EMAC1CLIENTRXSTATS5 (EMAC1CLIENTRXSTATS[5], EMAC1CLIENTRXSTATS_OUT[5]);
buf B_EMAC1CLIENTRXSTATS6 (EMAC1CLIENTRXSTATS[6], EMAC1CLIENTRXSTATS_OUT[6]);
buf B_EMAC1CLIENTRXSTATSBYTEVLD (EMAC1CLIENTRXSTATSBYTEVLD, EMAC1CLIENTRXSTATSBYTEVLD_OUT);
buf B_EMAC1CLIENTRXSTATSVLD (EMAC1CLIENTRXSTATSVLD, EMAC1CLIENTRXSTATSVLD_OUT);
buf B_EMAC1CLIENTTXACK (EMAC1CLIENTTXACK, EMAC1CLIENTTXACK_OUT);
buf B_EMAC1CLIENTTXCLIENTCLKOUT (EMAC1CLIENTTXCLIENTCLKOUT, EMAC1CLIENTTXCLIENTCLKOUT_OUT);
buf B_EMAC1CLIENTTXCOLLISION (EMAC1CLIENTTXCOLLISION, EMAC1CLIENTTXCOLLISION_OUT);
buf B_EMAC1CLIENTTXGMIIMIICLKOUT (EMAC1CLIENTTXGMIIMIICLKOUT, EMAC1CLIENTTXGMIIMIICLKOUT_OUT);
buf B_EMAC1CLIENTTXRETRANSMIT (EMAC1CLIENTTXRETRANSMIT, EMAC1CLIENTTXRETRANSMIT_OUT);
buf B_EMAC1CLIENTTXSTATS (EMAC1CLIENTTXSTATS, EMAC1CLIENTTXSTATS_OUT);
buf B_EMAC1CLIENTTXSTATSBYTEVLD (EMAC1CLIENTTXSTATSBYTEVLD, EMAC1CLIENTTXSTATSBYTEVLD_OUT);
buf B_EMAC1CLIENTTXSTATSVLD (EMAC1CLIENTTXSTATSVLD, EMAC1CLIENTTXSTATSVLD_OUT);
buf B_EMAC1PHYENCOMMAALIGN (EMAC1PHYENCOMMAALIGN, EMAC1PHYENCOMMAALIGN_OUT);
buf B_EMAC1PHYLOOPBACKMSB (EMAC1PHYLOOPBACKMSB, EMAC1PHYLOOPBACKMSB_OUT);
buf B_EMAC1PHYMCLKOUT (EMAC1PHYMCLKOUT, EMAC1PHYMCLKOUT_OUT);
buf B_EMAC1PHYMDOUT (EMAC1PHYMDOUT, EMAC1PHYMDOUT_OUT);
buf B_EMAC1PHYMDTRI (EMAC1PHYMDTRI, EMAC1PHYMDTRI_OUT);
buf B_EMAC1PHYMGTRXRESET (EMAC1PHYMGTRXRESET, EMAC1PHYMGTRXRESET_OUT);
buf B_EMAC1PHYMGTTXRESET (EMAC1PHYMGTTXRESET, EMAC1PHYMGTTXRESET_OUT);
buf B_EMAC1PHYPOWERDOWN (EMAC1PHYPOWERDOWN, EMAC1PHYPOWERDOWN_OUT);
buf B_EMAC1PHYSYNCACQSTATUS (EMAC1PHYSYNCACQSTATUS, EMAC1PHYSYNCACQSTATUS_OUT);
buf B_EMAC1PHYTXCHARDISPMODE (EMAC1PHYTXCHARDISPMODE, EMAC1PHYTXCHARDISPMODE_OUT);
buf B_EMAC1PHYTXCHARDISPVAL (EMAC1PHYTXCHARDISPVAL, EMAC1PHYTXCHARDISPVAL_OUT);
buf B_EMAC1PHYTXCHARISK (EMAC1PHYTXCHARISK, EMAC1PHYTXCHARISK_OUT);
buf B_EMAC1PHYTXCLK (EMAC1PHYTXCLK, EMAC1PHYTXCLK_OUT);
buf B_EMAC1PHYTXD0 (EMAC1PHYTXD[0], EMAC1PHYTXD_OUT[0]);
buf B_EMAC1PHYTXD1 (EMAC1PHYTXD[1], EMAC1PHYTXD_OUT[1]);
buf B_EMAC1PHYTXD2 (EMAC1PHYTXD[2], EMAC1PHYTXD_OUT[2]);
buf B_EMAC1PHYTXD3 (EMAC1PHYTXD[3], EMAC1PHYTXD_OUT[3]);
buf B_EMAC1PHYTXD4 (EMAC1PHYTXD[4], EMAC1PHYTXD_OUT[4]);
buf B_EMAC1PHYTXD5 (EMAC1PHYTXD[5], EMAC1PHYTXD_OUT[5]);
buf B_EMAC1PHYTXD6 (EMAC1PHYTXD[6], EMAC1PHYTXD_OUT[6]);
buf B_EMAC1PHYTXD7 (EMAC1PHYTXD[7], EMAC1PHYTXD_OUT[7]);
buf B_EMAC1PHYTXEN (EMAC1PHYTXEN, EMAC1PHYTXEN_OUT);
buf B_EMAC1PHYTXER (EMAC1PHYTXER, EMAC1PHYTXER_OUT);
buf B_HOSTMIIMRDY (HOSTMIIMRDY, HOSTMIIMRDY_OUT);
buf B_HOSTRDDATA0 (HOSTRDDATA[0], HOSTRDDATA_OUT[0]);
buf B_HOSTRDDATA1 (HOSTRDDATA[1], HOSTRDDATA_OUT[1]);
buf B_HOSTRDDATA2 (HOSTRDDATA[2], HOSTRDDATA_OUT[2]);
buf B_HOSTRDDATA3 (HOSTRDDATA[3], HOSTRDDATA_OUT[3]);
buf B_HOSTRDDATA4 (HOSTRDDATA[4], HOSTRDDATA_OUT[4]);
buf B_HOSTRDDATA5 (HOSTRDDATA[5], HOSTRDDATA_OUT[5]);
buf B_HOSTRDDATA6 (HOSTRDDATA[6], HOSTRDDATA_OUT[6]);
buf B_HOSTRDDATA7 (HOSTRDDATA[7], HOSTRDDATA_OUT[7]);
buf B_HOSTRDDATA8 (HOSTRDDATA[8], HOSTRDDATA_OUT[8]);
buf B_HOSTRDDATA9 (HOSTRDDATA[9], HOSTRDDATA_OUT[9]);
buf B_HOSTRDDATA10 (HOSTRDDATA[10], HOSTRDDATA_OUT[10]);
buf B_HOSTRDDATA11 (HOSTRDDATA[11], HOSTRDDATA_OUT[11]);
buf B_HOSTRDDATA12 (HOSTRDDATA[12], HOSTRDDATA_OUT[12]);
buf B_HOSTRDDATA13 (HOSTRDDATA[13], HOSTRDDATA_OUT[13]);
buf B_HOSTRDDATA14 (HOSTRDDATA[14], HOSTRDDATA_OUT[14]);
buf B_HOSTRDDATA15 (HOSTRDDATA[15], HOSTRDDATA_OUT[15]);
buf B_HOSTRDDATA16 (HOSTRDDATA[16], HOSTRDDATA_OUT[16]);
buf B_HOSTRDDATA17 (HOSTRDDATA[17], HOSTRDDATA_OUT[17]);
buf B_HOSTRDDATA18 (HOSTRDDATA[18], HOSTRDDATA_OUT[18]);
buf B_HOSTRDDATA19 (HOSTRDDATA[19], HOSTRDDATA_OUT[19]);
buf B_HOSTRDDATA20 (HOSTRDDATA[20], HOSTRDDATA_OUT[20]);
buf B_HOSTRDDATA21 (HOSTRDDATA[21], HOSTRDDATA_OUT[21]);
buf B_HOSTRDDATA22 (HOSTRDDATA[22], HOSTRDDATA_OUT[22]);
buf B_HOSTRDDATA23 (HOSTRDDATA[23], HOSTRDDATA_OUT[23]);
buf B_HOSTRDDATA24 (HOSTRDDATA[24], HOSTRDDATA_OUT[24]);
buf B_HOSTRDDATA25 (HOSTRDDATA[25], HOSTRDDATA_OUT[25]);
buf B_HOSTRDDATA26 (HOSTRDDATA[26], HOSTRDDATA_OUT[26]);
buf B_HOSTRDDATA27 (HOSTRDDATA[27], HOSTRDDATA_OUT[27]);
buf B_HOSTRDDATA28 (HOSTRDDATA[28], HOSTRDDATA_OUT[28]);
buf B_HOSTRDDATA29 (HOSTRDDATA[29], HOSTRDDATA_OUT[29]);
buf B_HOSTRDDATA30 (HOSTRDDATA[30], HOSTRDDATA_OUT[30]);
buf B_HOSTRDDATA31 (HOSTRDDATA[31], HOSTRDDATA_OUT[31]);
buf B_EMACDCRACK (EMACDCRACK, EMACDCRACK_OUT);

buf B_CLIENTEMAC0DCMLOCKED (CLIENTEMAC0DCMLOCKED_IN, CLIENTEMAC0DCMLOCKED);
buf B_CLIENTEMAC0PAUSEREQ (CLIENTEMAC0PAUSEREQ_IN, CLIENTEMAC0PAUSEREQ);
buf B_CLIENTEMAC0PAUSEVAL0 (CLIENTEMAC0PAUSEVAL_IN[0], CLIENTEMAC0PAUSEVAL[0]);
buf B_CLIENTEMAC0PAUSEVAL1 (CLIENTEMAC0PAUSEVAL_IN[1], CLIENTEMAC0PAUSEVAL[1]);
buf B_CLIENTEMAC0PAUSEVAL2 (CLIENTEMAC0PAUSEVAL_IN[2], CLIENTEMAC0PAUSEVAL[2]);
buf B_CLIENTEMAC0PAUSEVAL3 (CLIENTEMAC0PAUSEVAL_IN[3], CLIENTEMAC0PAUSEVAL[3]);
buf B_CLIENTEMAC0PAUSEVAL4 (CLIENTEMAC0PAUSEVAL_IN[4], CLIENTEMAC0PAUSEVAL[4]);
buf B_CLIENTEMAC0PAUSEVAL5 (CLIENTEMAC0PAUSEVAL_IN[5], CLIENTEMAC0PAUSEVAL[5]);
buf B_CLIENTEMAC0PAUSEVAL6 (CLIENTEMAC0PAUSEVAL_IN[6], CLIENTEMAC0PAUSEVAL[6]);
buf B_CLIENTEMAC0PAUSEVAL7 (CLIENTEMAC0PAUSEVAL_IN[7], CLIENTEMAC0PAUSEVAL[7]);
buf B_CLIENTEMAC0PAUSEVAL8 (CLIENTEMAC0PAUSEVAL_IN[8], CLIENTEMAC0PAUSEVAL[8]);
buf B_CLIENTEMAC0PAUSEVAL9 (CLIENTEMAC0PAUSEVAL_IN[9], CLIENTEMAC0PAUSEVAL[9]);
buf B_CLIENTEMAC0PAUSEVAL10 (CLIENTEMAC0PAUSEVAL_IN[10], CLIENTEMAC0PAUSEVAL[10]);
buf B_CLIENTEMAC0PAUSEVAL11 (CLIENTEMAC0PAUSEVAL_IN[11], CLIENTEMAC0PAUSEVAL[11]);
buf B_CLIENTEMAC0PAUSEVAL12 (CLIENTEMAC0PAUSEVAL_IN[12], CLIENTEMAC0PAUSEVAL[12]);
buf B_CLIENTEMAC0PAUSEVAL13 (CLIENTEMAC0PAUSEVAL_IN[13], CLIENTEMAC0PAUSEVAL[13]);
buf B_CLIENTEMAC0PAUSEVAL14 (CLIENTEMAC0PAUSEVAL_IN[14], CLIENTEMAC0PAUSEVAL[14]);
buf B_CLIENTEMAC0PAUSEVAL15 (CLIENTEMAC0PAUSEVAL_IN[15], CLIENTEMAC0PAUSEVAL[15]);
buf B_CLIENTEMAC0RXCLIENTCLKIN (CLIENTEMAC0RXCLIENTCLKIN_IN, CLIENTEMAC0RXCLIENTCLKIN);
buf B_CLIENTEMAC0TXCLIENTCLKIN (CLIENTEMAC0TXCLIENTCLKIN_IN, CLIENTEMAC0TXCLIENTCLKIN);
buf B_CLIENTEMAC0TXD0 (CLIENTEMAC0TXD_IN[0], CLIENTEMAC0TXD[0]);
buf B_CLIENTEMAC0TXD1 (CLIENTEMAC0TXD_IN[1], CLIENTEMAC0TXD[1]);
buf B_CLIENTEMAC0TXD2 (CLIENTEMAC0TXD_IN[2], CLIENTEMAC0TXD[2]);
buf B_CLIENTEMAC0TXD3 (CLIENTEMAC0TXD_IN[3], CLIENTEMAC0TXD[3]);
buf B_CLIENTEMAC0TXD4 (CLIENTEMAC0TXD_IN[4], CLIENTEMAC0TXD[4]);
buf B_CLIENTEMAC0TXD5 (CLIENTEMAC0TXD_IN[5], CLIENTEMAC0TXD[5]);
buf B_CLIENTEMAC0TXD6 (CLIENTEMAC0TXD_IN[6], CLIENTEMAC0TXD[6]);
buf B_CLIENTEMAC0TXD7 (CLIENTEMAC0TXD_IN[7], CLIENTEMAC0TXD[7]);
buf B_CLIENTEMAC0TXD8 (CLIENTEMAC0TXD_IN[8], CLIENTEMAC0TXD[8]);
buf B_CLIENTEMAC0TXD9 (CLIENTEMAC0TXD_IN[9], CLIENTEMAC0TXD[9]);
buf B_CLIENTEMAC0TXD10 (CLIENTEMAC0TXD_IN[10], CLIENTEMAC0TXD[10]);
buf B_CLIENTEMAC0TXD11 (CLIENTEMAC0TXD_IN[11], CLIENTEMAC0TXD[11]);
buf B_CLIENTEMAC0TXD12 (CLIENTEMAC0TXD_IN[12], CLIENTEMAC0TXD[12]);
buf B_CLIENTEMAC0TXD13 (CLIENTEMAC0TXD_IN[13], CLIENTEMAC0TXD[13]);
buf B_CLIENTEMAC0TXD14 (CLIENTEMAC0TXD_IN[14], CLIENTEMAC0TXD[14]);
buf B_CLIENTEMAC0TXD15 (CLIENTEMAC0TXD_IN[15], CLIENTEMAC0TXD[15]);
buf B_CLIENTEMAC0TXDVLD (CLIENTEMAC0TXDVLD_IN, CLIENTEMAC0TXDVLD);
buf B_CLIENTEMAC0TXDVLDMSW (CLIENTEMAC0TXDVLDMSW_IN, CLIENTEMAC0TXDVLDMSW);
buf B_CLIENTEMAC0TXFIRSTBYTE (CLIENTEMAC0TXFIRSTBYTE_IN, CLIENTEMAC0TXFIRSTBYTE);
buf B_CLIENTEMAC0TXGMIIMIICLKIN (CLIENTEMAC0TXGMIIMIICLKIN_IN, CLIENTEMAC0TXGMIIMIICLKIN);
buf B_CLIENTEMAC0TXIFGDELAY0 (CLIENTEMAC0TXIFGDELAY_IN[0], CLIENTEMAC0TXIFGDELAY[0]);
buf B_CLIENTEMAC0TXIFGDELAY1 (CLIENTEMAC0TXIFGDELAY_IN[1], CLIENTEMAC0TXIFGDELAY[1]);
buf B_CLIENTEMAC0TXIFGDELAY2 (CLIENTEMAC0TXIFGDELAY_IN[2], CLIENTEMAC0TXIFGDELAY[2]);
buf B_CLIENTEMAC0TXIFGDELAY3 (CLIENTEMAC0TXIFGDELAY_IN[3], CLIENTEMAC0TXIFGDELAY[3]);
buf B_CLIENTEMAC0TXIFGDELAY4 (CLIENTEMAC0TXIFGDELAY_IN[4], CLIENTEMAC0TXIFGDELAY[4]);
buf B_CLIENTEMAC0TXIFGDELAY5 (CLIENTEMAC0TXIFGDELAY_IN[5], CLIENTEMAC0TXIFGDELAY[5]);
buf B_CLIENTEMAC0TXIFGDELAY6 (CLIENTEMAC0TXIFGDELAY_IN[6], CLIENTEMAC0TXIFGDELAY[6]);
buf B_CLIENTEMAC0TXIFGDELAY7 (CLIENTEMAC0TXIFGDELAY_IN[7], CLIENTEMAC0TXIFGDELAY[7]);
buf B_CLIENTEMAC0TXUNDERRUN (CLIENTEMAC0TXUNDERRUN_IN, CLIENTEMAC0TXUNDERRUN);
buf B_CLIENTEMAC1DCMLOCKED (CLIENTEMAC1DCMLOCKED_IN, CLIENTEMAC1DCMLOCKED);
buf B_CLIENTEMAC1PAUSEREQ (CLIENTEMAC1PAUSEREQ_IN, CLIENTEMAC1PAUSEREQ);
buf B_CLIENTEMAC1PAUSEVAL0 (CLIENTEMAC1PAUSEVAL_IN[0], CLIENTEMAC1PAUSEVAL[0]);
buf B_CLIENTEMAC1PAUSEVAL1 (CLIENTEMAC1PAUSEVAL_IN[1], CLIENTEMAC1PAUSEVAL[1]);
buf B_CLIENTEMAC1PAUSEVAL2 (CLIENTEMAC1PAUSEVAL_IN[2], CLIENTEMAC1PAUSEVAL[2]);
buf B_CLIENTEMAC1PAUSEVAL3 (CLIENTEMAC1PAUSEVAL_IN[3], CLIENTEMAC1PAUSEVAL[3]);
buf B_CLIENTEMAC1PAUSEVAL4 (CLIENTEMAC1PAUSEVAL_IN[4], CLIENTEMAC1PAUSEVAL[4]);
buf B_CLIENTEMAC1PAUSEVAL5 (CLIENTEMAC1PAUSEVAL_IN[5], CLIENTEMAC1PAUSEVAL[5]);
buf B_CLIENTEMAC1PAUSEVAL6 (CLIENTEMAC1PAUSEVAL_IN[6], CLIENTEMAC1PAUSEVAL[6]);
buf B_CLIENTEMAC1PAUSEVAL7 (CLIENTEMAC1PAUSEVAL_IN[7], CLIENTEMAC1PAUSEVAL[7]);
buf B_CLIENTEMAC1PAUSEVAL8 (CLIENTEMAC1PAUSEVAL_IN[8], CLIENTEMAC1PAUSEVAL[8]);
buf B_CLIENTEMAC1PAUSEVAL9 (CLIENTEMAC1PAUSEVAL_IN[9], CLIENTEMAC1PAUSEVAL[9]);
buf B_CLIENTEMAC1PAUSEVAL10 (CLIENTEMAC1PAUSEVAL_IN[10], CLIENTEMAC1PAUSEVAL[10]);
buf B_CLIENTEMAC1PAUSEVAL11 (CLIENTEMAC1PAUSEVAL_IN[11], CLIENTEMAC1PAUSEVAL[11]);
buf B_CLIENTEMAC1PAUSEVAL12 (CLIENTEMAC1PAUSEVAL_IN[12], CLIENTEMAC1PAUSEVAL[12]);
buf B_CLIENTEMAC1PAUSEVAL13 (CLIENTEMAC1PAUSEVAL_IN[13], CLIENTEMAC1PAUSEVAL[13]);
buf B_CLIENTEMAC1PAUSEVAL14 (CLIENTEMAC1PAUSEVAL_IN[14], CLIENTEMAC1PAUSEVAL[14]);
buf B_CLIENTEMAC1PAUSEVAL15 (CLIENTEMAC1PAUSEVAL_IN[15], CLIENTEMAC1PAUSEVAL[15]);
buf B_CLIENTEMAC1RXCLIENTCLKIN (CLIENTEMAC1RXCLIENTCLKIN_IN, CLIENTEMAC1RXCLIENTCLKIN);
buf B_CLIENTEMAC1TXCLIENTCLKIN (CLIENTEMAC1TXCLIENTCLKIN_IN, CLIENTEMAC1TXCLIENTCLKIN);
buf B_CLIENTEMAC1TXD0 (CLIENTEMAC1TXD_IN[0], CLIENTEMAC1TXD[0]);
buf B_CLIENTEMAC1TXD1 (CLIENTEMAC1TXD_IN[1], CLIENTEMAC1TXD[1]);
buf B_CLIENTEMAC1TXD2 (CLIENTEMAC1TXD_IN[2], CLIENTEMAC1TXD[2]);
buf B_CLIENTEMAC1TXD3 (CLIENTEMAC1TXD_IN[3], CLIENTEMAC1TXD[3]);
buf B_CLIENTEMAC1TXD4 (CLIENTEMAC1TXD_IN[4], CLIENTEMAC1TXD[4]);
buf B_CLIENTEMAC1TXD5 (CLIENTEMAC1TXD_IN[5], CLIENTEMAC1TXD[5]);
buf B_CLIENTEMAC1TXD6 (CLIENTEMAC1TXD_IN[6], CLIENTEMAC1TXD[6]);
buf B_CLIENTEMAC1TXD7 (CLIENTEMAC1TXD_IN[7], CLIENTEMAC1TXD[7]);
buf B_CLIENTEMAC1TXD8 (CLIENTEMAC1TXD_IN[8], CLIENTEMAC1TXD[8]);
buf B_CLIENTEMAC1TXD9 (CLIENTEMAC1TXD_IN[9], CLIENTEMAC1TXD[9]);
buf B_CLIENTEMAC1TXD10 (CLIENTEMAC1TXD_IN[10], CLIENTEMAC1TXD[10]);
buf B_CLIENTEMAC1TXD11 (CLIENTEMAC1TXD_IN[11], CLIENTEMAC1TXD[11]);
buf B_CLIENTEMAC1TXD12 (CLIENTEMAC1TXD_IN[12], CLIENTEMAC1TXD[12]);
buf B_CLIENTEMAC1TXD13 (CLIENTEMAC1TXD_IN[13], CLIENTEMAC1TXD[13]);
buf B_CLIENTEMAC1TXD14 (CLIENTEMAC1TXD_IN[14], CLIENTEMAC1TXD[14]);
buf B_CLIENTEMAC1TXD15 (CLIENTEMAC1TXD_IN[15], CLIENTEMAC1TXD[15]);
buf B_CLIENTEMAC1TXDVLD (CLIENTEMAC1TXDVLD_IN, CLIENTEMAC1TXDVLD);
buf B_CLIENTEMAC1TXDVLDMSW (CLIENTEMAC1TXDVLDMSW_IN, CLIENTEMAC1TXDVLDMSW);
buf B_CLIENTEMAC1TXFIRSTBYTE (CLIENTEMAC1TXFIRSTBYTE_IN, CLIENTEMAC1TXFIRSTBYTE);
buf B_CLIENTEMAC1TXGMIIMIICLKIN (CLIENTEMAC1TXGMIIMIICLKIN_IN, CLIENTEMAC1TXGMIIMIICLKIN);
buf B_CLIENTEMAC1TXIFGDELAY0 (CLIENTEMAC1TXIFGDELAY_IN[0], CLIENTEMAC1TXIFGDELAY[0]);
buf B_CLIENTEMAC1TXIFGDELAY1 (CLIENTEMAC1TXIFGDELAY_IN[1], CLIENTEMAC1TXIFGDELAY[1]);
buf B_CLIENTEMAC1TXIFGDELAY2 (CLIENTEMAC1TXIFGDELAY_IN[2], CLIENTEMAC1TXIFGDELAY[2]);
buf B_CLIENTEMAC1TXIFGDELAY3 (CLIENTEMAC1TXIFGDELAY_IN[3], CLIENTEMAC1TXIFGDELAY[3]);
buf B_CLIENTEMAC1TXIFGDELAY4 (CLIENTEMAC1TXIFGDELAY_IN[4], CLIENTEMAC1TXIFGDELAY[4]);
buf B_CLIENTEMAC1TXIFGDELAY5 (CLIENTEMAC1TXIFGDELAY_IN[5], CLIENTEMAC1TXIFGDELAY[5]);
buf B_CLIENTEMAC1TXIFGDELAY6 (CLIENTEMAC1TXIFGDELAY_IN[6], CLIENTEMAC1TXIFGDELAY[6]);
buf B_CLIENTEMAC1TXIFGDELAY7 (CLIENTEMAC1TXIFGDELAY_IN[7], CLIENTEMAC1TXIFGDELAY[7]);
buf B_CLIENTEMAC1TXUNDERRUN (CLIENTEMAC1TXUNDERRUN_IN, CLIENTEMAC1TXUNDERRUN);
buf B_DCREMACENABLE (DCREMACENABLE_IN, DCREMACENABLE);
buf B_HOSTADDR0 (HOSTADDR_IN[0], HOSTADDR[0]);
buf B_HOSTADDR1 (HOSTADDR_IN[1], HOSTADDR[1]);
buf B_HOSTADDR2 (HOSTADDR_IN[2], HOSTADDR[2]);
buf B_HOSTADDR3 (HOSTADDR_IN[3], HOSTADDR[3]);
buf B_HOSTADDR4 (HOSTADDR_IN[4], HOSTADDR[4]);
buf B_HOSTADDR5 (HOSTADDR_IN[5], HOSTADDR[5]);
buf B_HOSTADDR6 (HOSTADDR_IN[6], HOSTADDR[6]);
buf B_HOSTADDR7 (HOSTADDR_IN[7], HOSTADDR[7]);
buf B_HOSTADDR8 (HOSTADDR_IN[8], HOSTADDR[8]);
buf B_HOSTADDR9 (HOSTADDR_IN[9], HOSTADDR[9]);
buf B_HOSTCLK (HOSTCLK_IN, HOSTCLK);
buf B_HOSTEMAC1SEL (HOSTEMAC1SEL_IN, HOSTEMAC1SEL);
buf B_HOSTMIIMSEL (HOSTMIIMSEL_IN, HOSTMIIMSEL);
buf B_HOSTOPCODE0 (HOSTOPCODE_IN[0], HOSTOPCODE[0]);
buf B_HOSTOPCODE1 (HOSTOPCODE_IN[1], HOSTOPCODE[1]);
buf B_HOSTREQ (HOSTREQ_IN, HOSTREQ);
buf B_HOSTWRDATA0 (HOSTWRDATA_IN[0], HOSTWRDATA[0]);
buf B_HOSTWRDATA1 (HOSTWRDATA_IN[1], HOSTWRDATA[1]);
buf B_HOSTWRDATA2 (HOSTWRDATA_IN[2], HOSTWRDATA[2]);
buf B_HOSTWRDATA3 (HOSTWRDATA_IN[3], HOSTWRDATA[3]);
buf B_HOSTWRDATA4 (HOSTWRDATA_IN[4], HOSTWRDATA[4]);
buf B_HOSTWRDATA5 (HOSTWRDATA_IN[5], HOSTWRDATA[5]);
buf B_HOSTWRDATA6 (HOSTWRDATA_IN[6], HOSTWRDATA[6]);
buf B_HOSTWRDATA7 (HOSTWRDATA_IN[7], HOSTWRDATA[7]);
buf B_HOSTWRDATA8 (HOSTWRDATA_IN[8], HOSTWRDATA[8]);
buf B_HOSTWRDATA9 (HOSTWRDATA_IN[9], HOSTWRDATA[9]);
buf B_HOSTWRDATA10 (HOSTWRDATA_IN[10], HOSTWRDATA[10]);
buf B_HOSTWRDATA11 (HOSTWRDATA_IN[11], HOSTWRDATA[11]);
buf B_HOSTWRDATA12 (HOSTWRDATA_IN[12], HOSTWRDATA[12]);
buf B_HOSTWRDATA13 (HOSTWRDATA_IN[13], HOSTWRDATA[13]);
buf B_HOSTWRDATA14 (HOSTWRDATA_IN[14], HOSTWRDATA[14]);
buf B_HOSTWRDATA15 (HOSTWRDATA_IN[15], HOSTWRDATA[15]);
buf B_HOSTWRDATA16 (HOSTWRDATA_IN[16], HOSTWRDATA[16]);
buf B_HOSTWRDATA17 (HOSTWRDATA_IN[17], HOSTWRDATA[17]);
buf B_HOSTWRDATA18 (HOSTWRDATA_IN[18], HOSTWRDATA[18]);
buf B_HOSTWRDATA19 (HOSTWRDATA_IN[19], HOSTWRDATA[19]);
buf B_HOSTWRDATA20 (HOSTWRDATA_IN[20], HOSTWRDATA[20]);
buf B_HOSTWRDATA21 (HOSTWRDATA_IN[21], HOSTWRDATA[21]);
buf B_HOSTWRDATA22 (HOSTWRDATA_IN[22], HOSTWRDATA[22]);
buf B_HOSTWRDATA23 (HOSTWRDATA_IN[23], HOSTWRDATA[23]);
buf B_HOSTWRDATA24 (HOSTWRDATA_IN[24], HOSTWRDATA[24]);
buf B_HOSTWRDATA25 (HOSTWRDATA_IN[25], HOSTWRDATA[25]);
buf B_HOSTWRDATA26 (HOSTWRDATA_IN[26], HOSTWRDATA[26]);
buf B_HOSTWRDATA27 (HOSTWRDATA_IN[27], HOSTWRDATA[27]);
buf B_HOSTWRDATA28 (HOSTWRDATA_IN[28], HOSTWRDATA[28]);
buf B_HOSTWRDATA29 (HOSTWRDATA_IN[29], HOSTWRDATA[29]);
buf B_HOSTWRDATA30 (HOSTWRDATA_IN[30], HOSTWRDATA[30]);
buf B_HOSTWRDATA31 (HOSTWRDATA_IN[31], HOSTWRDATA[31]);
buf B_PHYEMAC0COL (PHYEMAC0COL_IN, PHYEMAC0COL);
buf B_PHYEMAC0CRS (PHYEMAC0CRS_IN, PHYEMAC0CRS);
buf B_PHYEMAC0GTXCLK (PHYEMAC0GTXCLK_IN, PHYEMAC0GTXCLK);
buf B_PHYEMAC0MCLKIN (PHYEMAC0MCLKIN_IN, PHYEMAC0MCLKIN);
buf B_PHYEMAC0MDIN (PHYEMAC0MDIN_IN, PHYEMAC0MDIN);
buf B_PHYEMAC0MIITXCLK (PHYEMAC0MIITXCLK_IN, PHYEMAC0MIITXCLK);
buf B_PHYEMAC0PHYAD0 (PHYEMAC0PHYAD_IN[0], PHYEMAC0PHYAD[0]);
buf B_PHYEMAC0PHYAD1 (PHYEMAC0PHYAD_IN[1], PHYEMAC0PHYAD[1]);
buf B_PHYEMAC0PHYAD2 (PHYEMAC0PHYAD_IN[2], PHYEMAC0PHYAD[2]);
buf B_PHYEMAC0PHYAD3 (PHYEMAC0PHYAD_IN[3], PHYEMAC0PHYAD[3]);
buf B_PHYEMAC0PHYAD4 (PHYEMAC0PHYAD_IN[4], PHYEMAC0PHYAD[4]);
buf B_PHYEMAC0RXBUFERR (PHYEMAC0RXBUFERR_IN, PHYEMAC0RXBUFERR);
buf B_PHYEMAC0RXBUFSTATUS0 (PHYEMAC0RXBUFSTATUS_IN[0], PHYEMAC0RXBUFSTATUS[0]);
buf B_PHYEMAC0RXBUFSTATUS1 (PHYEMAC0RXBUFSTATUS_IN[1], PHYEMAC0RXBUFSTATUS[1]);
buf B_PHYEMAC0RXCHARISCOMMA (PHYEMAC0RXCHARISCOMMA_IN, PHYEMAC0RXCHARISCOMMA);
buf B_PHYEMAC0RXCHARISK (PHYEMAC0RXCHARISK_IN, PHYEMAC0RXCHARISK);
buf B_PHYEMAC0RXCHECKINGCRC (PHYEMAC0RXCHECKINGCRC_IN, PHYEMAC0RXCHECKINGCRC);
buf B_PHYEMAC0RXCLK (PHYEMAC0RXCLK_IN, PHYEMAC0RXCLK);
buf B_PHYEMAC0RXCLKCORCNT0 (PHYEMAC0RXCLKCORCNT_IN[0], PHYEMAC0RXCLKCORCNT[0]);
buf B_PHYEMAC0RXCLKCORCNT1 (PHYEMAC0RXCLKCORCNT_IN[1], PHYEMAC0RXCLKCORCNT[1]);
buf B_PHYEMAC0RXCLKCORCNT2 (PHYEMAC0RXCLKCORCNT_IN[2], PHYEMAC0RXCLKCORCNT[2]);
buf B_PHYEMAC0RXCOMMADET (PHYEMAC0RXCOMMADET_IN, PHYEMAC0RXCOMMADET);
buf B_PHYEMAC0RXD0 (PHYEMAC0RXD_IN[0], PHYEMAC0RXD[0]);
buf B_PHYEMAC0RXD1 (PHYEMAC0RXD_IN[1], PHYEMAC0RXD[1]);
buf B_PHYEMAC0RXD2 (PHYEMAC0RXD_IN[2], PHYEMAC0RXD[2]);
buf B_PHYEMAC0RXD3 (PHYEMAC0RXD_IN[3], PHYEMAC0RXD[3]);
buf B_PHYEMAC0RXD4 (PHYEMAC0RXD_IN[4], PHYEMAC0RXD[4]);
buf B_PHYEMAC0RXD5 (PHYEMAC0RXD_IN[5], PHYEMAC0RXD[5]);
buf B_PHYEMAC0RXD6 (PHYEMAC0RXD_IN[6], PHYEMAC0RXD[6]);
buf B_PHYEMAC0RXD7 (PHYEMAC0RXD_IN[7], PHYEMAC0RXD[7]);
buf B_PHYEMAC0RXDISPERR (PHYEMAC0RXDISPERR_IN, PHYEMAC0RXDISPERR);
buf B_PHYEMAC0RXDV (PHYEMAC0RXDV_IN, PHYEMAC0RXDV);
buf B_PHYEMAC0RXER (PHYEMAC0RXER_IN, PHYEMAC0RXER);
buf B_PHYEMAC0RXLOSSOFSYNC0 (PHYEMAC0RXLOSSOFSYNC_IN[0], PHYEMAC0RXLOSSOFSYNC[0]);
buf B_PHYEMAC0RXLOSSOFSYNC1 (PHYEMAC0RXLOSSOFSYNC_IN[1], PHYEMAC0RXLOSSOFSYNC[1]);
buf B_PHYEMAC0RXNOTINTABLE (PHYEMAC0RXNOTINTABLE_IN, PHYEMAC0RXNOTINTABLE);
buf B_PHYEMAC0RXRUNDISP (PHYEMAC0RXRUNDISP_IN, PHYEMAC0RXRUNDISP);
buf B_PHYEMAC0SIGNALDET (PHYEMAC0SIGNALDET_IN, PHYEMAC0SIGNALDET);
buf B_PHYEMAC0TXBUFERR (PHYEMAC0TXBUFERR_IN, PHYEMAC0TXBUFERR);
buf B_PHYEMAC1COL (PHYEMAC1COL_IN, PHYEMAC1COL);
buf B_PHYEMAC1CRS (PHYEMAC1CRS_IN, PHYEMAC1CRS);
buf B_PHYEMAC1GTXCLK (PHYEMAC1GTXCLK_IN, PHYEMAC1GTXCLK);
buf B_PHYEMAC1MCLKIN (PHYEMAC1MCLKIN_IN, PHYEMAC1MCLKIN);
buf B_PHYEMAC1MDIN (PHYEMAC1MDIN_IN, PHYEMAC1MDIN);
buf B_PHYEMAC1MIITXCLK (PHYEMAC1MIITXCLK_IN, PHYEMAC1MIITXCLK);
buf B_PHYEMAC1PHYAD0 (PHYEMAC1PHYAD_IN[0], PHYEMAC1PHYAD[0]);
buf B_PHYEMAC1PHYAD1 (PHYEMAC1PHYAD_IN[1], PHYEMAC1PHYAD[1]);
buf B_PHYEMAC1PHYAD2 (PHYEMAC1PHYAD_IN[2], PHYEMAC1PHYAD[2]);
buf B_PHYEMAC1PHYAD3 (PHYEMAC1PHYAD_IN[3], PHYEMAC1PHYAD[3]);
buf B_PHYEMAC1PHYAD4 (PHYEMAC1PHYAD_IN[4], PHYEMAC1PHYAD[4]);
buf B_PHYEMAC1RXBUFERR (PHYEMAC1RXBUFERR_IN, PHYEMAC1RXBUFERR);
buf B_PHYEMAC1RXBUFSTATUS0 (PHYEMAC1RXBUFSTATUS_IN[0], PHYEMAC1RXBUFSTATUS[0]);
buf B_PHYEMAC1RXBUFSTATUS1 (PHYEMAC1RXBUFSTATUS_IN[1], PHYEMAC1RXBUFSTATUS[1]);
buf B_PHYEMAC1RXCHARISCOMMA (PHYEMAC1RXCHARISCOMMA_IN, PHYEMAC1RXCHARISCOMMA);
buf B_PHYEMAC1RXCHARISK (PHYEMAC1RXCHARISK_IN, PHYEMAC1RXCHARISK);
buf B_PHYEMAC1RXCHECKINGCRC (PHYEMAC1RXCHECKINGCRC_IN, PHYEMAC1RXCHECKINGCRC);
buf B_PHYEMAC1RXCLK (PHYEMAC1RXCLK_IN, PHYEMAC1RXCLK);
buf B_PHYEMAC1RXCLKCORCNT0 (PHYEMAC1RXCLKCORCNT_IN[0], PHYEMAC1RXCLKCORCNT[0]);
buf B_PHYEMAC1RXCLKCORCNT1 (PHYEMAC1RXCLKCORCNT_IN[1], PHYEMAC1RXCLKCORCNT[1]);
buf B_PHYEMAC1RXCLKCORCNT2 (PHYEMAC1RXCLKCORCNT_IN[2], PHYEMAC1RXCLKCORCNT[2]);
buf B_PHYEMAC1RXCOMMADET (PHYEMAC1RXCOMMADET_IN, PHYEMAC1RXCOMMADET);
buf B_PHYEMAC1RXD0 (PHYEMAC1RXD_IN[0], PHYEMAC1RXD[0]);
buf B_PHYEMAC1RXD1 (PHYEMAC1RXD_IN[1], PHYEMAC1RXD[1]);
buf B_PHYEMAC1RXD2 (PHYEMAC1RXD_IN[2], PHYEMAC1RXD[2]);
buf B_PHYEMAC1RXD3 (PHYEMAC1RXD_IN[3], PHYEMAC1RXD[3]);
buf B_PHYEMAC1RXD4 (PHYEMAC1RXD_IN[4], PHYEMAC1RXD[4]);
buf B_PHYEMAC1RXD5 (PHYEMAC1RXD_IN[5], PHYEMAC1RXD[5]);
buf B_PHYEMAC1RXD6 (PHYEMAC1RXD_IN[6], PHYEMAC1RXD[6]);
buf B_PHYEMAC1RXD7 (PHYEMAC1RXD_IN[7], PHYEMAC1RXD[7]);
buf B_PHYEMAC1RXDISPERR (PHYEMAC1RXDISPERR_IN, PHYEMAC1RXDISPERR);
buf B_PHYEMAC1RXDV (PHYEMAC1RXDV_IN, PHYEMAC1RXDV);
buf B_PHYEMAC1RXER (PHYEMAC1RXER_IN, PHYEMAC1RXER);
buf B_PHYEMAC1RXLOSSOFSYNC0 (PHYEMAC1RXLOSSOFSYNC_IN[0], PHYEMAC1RXLOSSOFSYNC[0]);
buf B_PHYEMAC1RXLOSSOFSYNC1 (PHYEMAC1RXLOSSOFSYNC_IN[1], PHYEMAC1RXLOSSOFSYNC[1]);
buf B_PHYEMAC1RXNOTINTABLE (PHYEMAC1RXNOTINTABLE_IN, PHYEMAC1RXNOTINTABLE);
buf B_PHYEMAC1RXRUNDISP (PHYEMAC1RXRUNDISP_IN, PHYEMAC1RXRUNDISP);
buf B_PHYEMAC1SIGNALDET (PHYEMAC1SIGNALDET_IN, PHYEMAC1SIGNALDET);
buf B_PHYEMAC1TXBUFERR (PHYEMAC1TXBUFERR_IN, PHYEMAC1TXBUFERR);
buf B_RESET (RESET_IN, RESET);
buf B_TIEEMAC0CONFIGVEC0 (TIEEMAC0CONFIGVEC_IN[0], TIEEMAC0CONFIGVEC[0]);
buf B_TIEEMAC0CONFIGVEC1 (TIEEMAC0CONFIGVEC_IN[1], TIEEMAC0CONFIGVEC[1]);
buf B_TIEEMAC0CONFIGVEC2 (TIEEMAC0CONFIGVEC_IN[2], TIEEMAC0CONFIGVEC[2]);
buf B_TIEEMAC0CONFIGVEC3 (TIEEMAC0CONFIGVEC_IN[3], TIEEMAC0CONFIGVEC[3]);
buf B_TIEEMAC0CONFIGVEC4 (TIEEMAC0CONFIGVEC_IN[4], TIEEMAC0CONFIGVEC[4]);
buf B_TIEEMAC0CONFIGVEC5 (TIEEMAC0CONFIGVEC_IN[5], TIEEMAC0CONFIGVEC[5]);
buf B_TIEEMAC0CONFIGVEC6 (TIEEMAC0CONFIGVEC_IN[6], TIEEMAC0CONFIGVEC[6]);
buf B_TIEEMAC0CONFIGVEC7 (TIEEMAC0CONFIGVEC_IN[7], TIEEMAC0CONFIGVEC[7]);
buf B_TIEEMAC0CONFIGVEC8 (TIEEMAC0CONFIGVEC_IN[8], TIEEMAC0CONFIGVEC[8]);
buf B_TIEEMAC0CONFIGVEC9 (TIEEMAC0CONFIGVEC_IN[9], TIEEMAC0CONFIGVEC[9]);
buf B_TIEEMAC0CONFIGVEC10 (TIEEMAC0CONFIGVEC_IN[10], TIEEMAC0CONFIGVEC[10]);
buf B_TIEEMAC0CONFIGVEC11 (TIEEMAC0CONFIGVEC_IN[11], TIEEMAC0CONFIGVEC[11]);
buf B_TIEEMAC0CONFIGVEC12 (TIEEMAC0CONFIGVEC_IN[12], TIEEMAC0CONFIGVEC[12]);
buf B_TIEEMAC0CONFIGVEC13 (TIEEMAC0CONFIGVEC_IN[13], TIEEMAC0CONFIGVEC[13]);
buf B_TIEEMAC0CONFIGVEC14 (TIEEMAC0CONFIGVEC_IN[14], TIEEMAC0CONFIGVEC[14]);
buf B_TIEEMAC0CONFIGVEC15 (TIEEMAC0CONFIGVEC_IN[15], TIEEMAC0CONFIGVEC[15]);
buf B_TIEEMAC0CONFIGVEC16 (TIEEMAC0CONFIGVEC_IN[16], TIEEMAC0CONFIGVEC[16]);
buf B_TIEEMAC0CONFIGVEC17 (TIEEMAC0CONFIGVEC_IN[17], TIEEMAC0CONFIGVEC[17]);
buf B_TIEEMAC0CONFIGVEC18 (TIEEMAC0CONFIGVEC_IN[18], TIEEMAC0CONFIGVEC[18]);
buf B_TIEEMAC0CONFIGVEC19 (TIEEMAC0CONFIGVEC_IN[19], TIEEMAC0CONFIGVEC[19]);
buf B_TIEEMAC0CONFIGVEC20 (TIEEMAC0CONFIGVEC_IN[20], TIEEMAC0CONFIGVEC[20]);
buf B_TIEEMAC0CONFIGVEC21 (TIEEMAC0CONFIGVEC_IN[21], TIEEMAC0CONFIGVEC[21]);
buf B_TIEEMAC0CONFIGVEC22 (TIEEMAC0CONFIGVEC_IN[22], TIEEMAC0CONFIGVEC[22]);
buf B_TIEEMAC0CONFIGVEC23 (TIEEMAC0CONFIGVEC_IN[23], TIEEMAC0CONFIGVEC[23]);
buf B_TIEEMAC0CONFIGVEC24 (TIEEMAC0CONFIGVEC_IN[24], TIEEMAC0CONFIGVEC[24]);
buf B_TIEEMAC0CONFIGVEC25 (TIEEMAC0CONFIGVEC_IN[25], TIEEMAC0CONFIGVEC[25]);
buf B_TIEEMAC0CONFIGVEC26 (TIEEMAC0CONFIGVEC_IN[26], TIEEMAC0CONFIGVEC[26]);
buf B_TIEEMAC0CONFIGVEC27 (TIEEMAC0CONFIGVEC_IN[27], TIEEMAC0CONFIGVEC[27]);
buf B_TIEEMAC0CONFIGVEC28 (TIEEMAC0CONFIGVEC_IN[28], TIEEMAC0CONFIGVEC[28]);
buf B_TIEEMAC0CONFIGVEC29 (TIEEMAC0CONFIGVEC_IN[29], TIEEMAC0CONFIGVEC[29]);
buf B_TIEEMAC0CONFIGVEC30 (TIEEMAC0CONFIGVEC_IN[30], TIEEMAC0CONFIGVEC[30]);
buf B_TIEEMAC0CONFIGVEC31 (TIEEMAC0CONFIGVEC_IN[31], TIEEMAC0CONFIGVEC[31]);
buf B_TIEEMAC0CONFIGVEC32 (TIEEMAC0CONFIGVEC_IN[32], TIEEMAC0CONFIGVEC[32]);
buf B_TIEEMAC0CONFIGVEC33 (TIEEMAC0CONFIGVEC_IN[33], TIEEMAC0CONFIGVEC[33]);
buf B_TIEEMAC0CONFIGVEC34 (TIEEMAC0CONFIGVEC_IN[34], TIEEMAC0CONFIGVEC[34]);
buf B_TIEEMAC0CONFIGVEC35 (TIEEMAC0CONFIGVEC_IN[35], TIEEMAC0CONFIGVEC[35]);
buf B_TIEEMAC0CONFIGVEC36 (TIEEMAC0CONFIGVEC_IN[36], TIEEMAC0CONFIGVEC[36]);
buf B_TIEEMAC0CONFIGVEC37 (TIEEMAC0CONFIGVEC_IN[37], TIEEMAC0CONFIGVEC[37]);
buf B_TIEEMAC0CONFIGVEC38 (TIEEMAC0CONFIGVEC_IN[38], TIEEMAC0CONFIGVEC[38]);
buf B_TIEEMAC0CONFIGVEC39 (TIEEMAC0CONFIGVEC_IN[39], TIEEMAC0CONFIGVEC[39]);
buf B_TIEEMAC0CONFIGVEC40 (TIEEMAC0CONFIGVEC_IN[40], TIEEMAC0CONFIGVEC[40]);
buf B_TIEEMAC0CONFIGVEC41 (TIEEMAC0CONFIGVEC_IN[41], TIEEMAC0CONFIGVEC[41]);
buf B_TIEEMAC0CONFIGVEC42 (TIEEMAC0CONFIGVEC_IN[42], TIEEMAC0CONFIGVEC[42]);
buf B_TIEEMAC0CONFIGVEC43 (TIEEMAC0CONFIGVEC_IN[43], TIEEMAC0CONFIGVEC[43]);
buf B_TIEEMAC0CONFIGVEC44 (TIEEMAC0CONFIGVEC_IN[44], TIEEMAC0CONFIGVEC[44]);
buf B_TIEEMAC0CONFIGVEC45 (TIEEMAC0CONFIGVEC_IN[45], TIEEMAC0CONFIGVEC[45]);
buf B_TIEEMAC0CONFIGVEC46 (TIEEMAC0CONFIGVEC_IN[46], TIEEMAC0CONFIGVEC[46]);
buf B_TIEEMAC0CONFIGVEC47 (TIEEMAC0CONFIGVEC_IN[47], TIEEMAC0CONFIGVEC[47]);
buf B_TIEEMAC0CONFIGVEC48 (TIEEMAC0CONFIGVEC_IN[48], TIEEMAC0CONFIGVEC[48]);
buf B_TIEEMAC0CONFIGVEC49 (TIEEMAC0CONFIGVEC_IN[49], TIEEMAC0CONFIGVEC[49]);
buf B_TIEEMAC0CONFIGVEC50 (TIEEMAC0CONFIGVEC_IN[50], TIEEMAC0CONFIGVEC[50]);
buf B_TIEEMAC0CONFIGVEC51 (TIEEMAC0CONFIGVEC_IN[51], TIEEMAC0CONFIGVEC[51]);
buf B_TIEEMAC0CONFIGVEC52 (TIEEMAC0CONFIGVEC_IN[52], TIEEMAC0CONFIGVEC[52]);
buf B_TIEEMAC0CONFIGVEC53 (TIEEMAC0CONFIGVEC_IN[53], TIEEMAC0CONFIGVEC[53]);
buf B_TIEEMAC0CONFIGVEC54 (TIEEMAC0CONFIGVEC_IN[54], TIEEMAC0CONFIGVEC[54]);
buf B_TIEEMAC0CONFIGVEC55 (TIEEMAC0CONFIGVEC_IN[55], TIEEMAC0CONFIGVEC[55]);
buf B_TIEEMAC0CONFIGVEC56 (TIEEMAC0CONFIGVEC_IN[56], TIEEMAC0CONFIGVEC[56]);
buf B_TIEEMAC0CONFIGVEC57 (TIEEMAC0CONFIGVEC_IN[57], TIEEMAC0CONFIGVEC[57]);
buf B_TIEEMAC0CONFIGVEC58 (TIEEMAC0CONFIGVEC_IN[58], TIEEMAC0CONFIGVEC[58]);
buf B_TIEEMAC0CONFIGVEC59 (TIEEMAC0CONFIGVEC_IN[59], TIEEMAC0CONFIGVEC[59]);
buf B_TIEEMAC0CONFIGVEC60 (TIEEMAC0CONFIGVEC_IN[60], TIEEMAC0CONFIGVEC[60]);
buf B_TIEEMAC0CONFIGVEC61 (TIEEMAC0CONFIGVEC_IN[61], TIEEMAC0CONFIGVEC[61]);
buf B_TIEEMAC0CONFIGVEC62 (TIEEMAC0CONFIGVEC_IN[62], TIEEMAC0CONFIGVEC[62]);
buf B_TIEEMAC0CONFIGVEC63 (TIEEMAC0CONFIGVEC_IN[63], TIEEMAC0CONFIGVEC[63]);
buf B_TIEEMAC0CONFIGVEC64 (TIEEMAC0CONFIGVEC_IN[64], TIEEMAC0CONFIGVEC[64]);
buf B_TIEEMAC0CONFIGVEC65 (TIEEMAC0CONFIGVEC_IN[65], TIEEMAC0CONFIGVEC[65]);
buf B_TIEEMAC0CONFIGVEC66 (TIEEMAC0CONFIGVEC_IN[66], TIEEMAC0CONFIGVEC[66]);
buf B_TIEEMAC0CONFIGVEC67 (TIEEMAC0CONFIGVEC_IN[67], TIEEMAC0CONFIGVEC[67]);
buf B_TIEEMAC0CONFIGVEC68 (TIEEMAC0CONFIGVEC_IN[68], TIEEMAC0CONFIGVEC[68]);
buf B_TIEEMAC0CONFIGVEC69 (TIEEMAC0CONFIGVEC_IN[69], TIEEMAC0CONFIGVEC[69]);
buf B_TIEEMAC0CONFIGVEC70 (TIEEMAC0CONFIGVEC_IN[70], TIEEMAC0CONFIGVEC[70]);
buf B_TIEEMAC0CONFIGVEC71 (TIEEMAC0CONFIGVEC_IN[71], TIEEMAC0CONFIGVEC[71]);
buf B_TIEEMAC0CONFIGVEC72 (TIEEMAC0CONFIGVEC_IN[72], TIEEMAC0CONFIGVEC[72]);
buf B_TIEEMAC0CONFIGVEC73 (TIEEMAC0CONFIGVEC_IN[73], TIEEMAC0CONFIGVEC[73]);
buf B_TIEEMAC0CONFIGVEC74 (TIEEMAC0CONFIGVEC_IN[74], TIEEMAC0CONFIGVEC[74]);
buf B_TIEEMAC0CONFIGVEC75 (TIEEMAC0CONFIGVEC_IN[75], TIEEMAC0CONFIGVEC[75]);
buf B_TIEEMAC0CONFIGVEC76 (TIEEMAC0CONFIGVEC_IN[76], TIEEMAC0CONFIGVEC[76]);
buf B_TIEEMAC0CONFIGVEC77 (TIEEMAC0CONFIGVEC_IN[77], TIEEMAC0CONFIGVEC[77]);
buf B_TIEEMAC0CONFIGVEC78 (TIEEMAC0CONFIGVEC_IN[78], TIEEMAC0CONFIGVEC[78]);
buf B_TIEEMAC0CONFIGVEC79 (TIEEMAC0CONFIGVEC_IN[79], TIEEMAC0CONFIGVEC[79]);
buf B_TIEEMAC0UNICASTADDR0 (TIEEMAC0UNICASTADDR_IN[0], TIEEMAC0UNICASTADDR[0]);
buf B_TIEEMAC0UNICASTADDR1 (TIEEMAC0UNICASTADDR_IN[1], TIEEMAC0UNICASTADDR[1]);
buf B_TIEEMAC0UNICASTADDR2 (TIEEMAC0UNICASTADDR_IN[2], TIEEMAC0UNICASTADDR[2]);
buf B_TIEEMAC0UNICASTADDR3 (TIEEMAC0UNICASTADDR_IN[3], TIEEMAC0UNICASTADDR[3]);
buf B_TIEEMAC0UNICASTADDR4 (TIEEMAC0UNICASTADDR_IN[4], TIEEMAC0UNICASTADDR[4]);
buf B_TIEEMAC0UNICASTADDR5 (TIEEMAC0UNICASTADDR_IN[5], TIEEMAC0UNICASTADDR[5]);
buf B_TIEEMAC0UNICASTADDR6 (TIEEMAC0UNICASTADDR_IN[6], TIEEMAC0UNICASTADDR[6]);
buf B_TIEEMAC0UNICASTADDR7 (TIEEMAC0UNICASTADDR_IN[7], TIEEMAC0UNICASTADDR[7]);
buf B_TIEEMAC0UNICASTADDR8 (TIEEMAC0UNICASTADDR_IN[8], TIEEMAC0UNICASTADDR[8]);
buf B_TIEEMAC0UNICASTADDR9 (TIEEMAC0UNICASTADDR_IN[9], TIEEMAC0UNICASTADDR[9]);
buf B_TIEEMAC0UNICASTADDR10 (TIEEMAC0UNICASTADDR_IN[10], TIEEMAC0UNICASTADDR[10]);
buf B_TIEEMAC0UNICASTADDR11 (TIEEMAC0UNICASTADDR_IN[11], TIEEMAC0UNICASTADDR[11]);
buf B_TIEEMAC0UNICASTADDR12 (TIEEMAC0UNICASTADDR_IN[12], TIEEMAC0UNICASTADDR[12]);
buf B_TIEEMAC0UNICASTADDR13 (TIEEMAC0UNICASTADDR_IN[13], TIEEMAC0UNICASTADDR[13]);
buf B_TIEEMAC0UNICASTADDR14 (TIEEMAC0UNICASTADDR_IN[14], TIEEMAC0UNICASTADDR[14]);
buf B_TIEEMAC0UNICASTADDR15 (TIEEMAC0UNICASTADDR_IN[15], TIEEMAC0UNICASTADDR[15]);
buf B_TIEEMAC0UNICASTADDR16 (TIEEMAC0UNICASTADDR_IN[16], TIEEMAC0UNICASTADDR[16]);
buf B_TIEEMAC0UNICASTADDR17 (TIEEMAC0UNICASTADDR_IN[17], TIEEMAC0UNICASTADDR[17]);
buf B_TIEEMAC0UNICASTADDR18 (TIEEMAC0UNICASTADDR_IN[18], TIEEMAC0UNICASTADDR[18]);
buf B_TIEEMAC0UNICASTADDR19 (TIEEMAC0UNICASTADDR_IN[19], TIEEMAC0UNICASTADDR[19]);
buf B_TIEEMAC0UNICASTADDR20 (TIEEMAC0UNICASTADDR_IN[20], TIEEMAC0UNICASTADDR[20]);
buf B_TIEEMAC0UNICASTADDR21 (TIEEMAC0UNICASTADDR_IN[21], TIEEMAC0UNICASTADDR[21]);
buf B_TIEEMAC0UNICASTADDR22 (TIEEMAC0UNICASTADDR_IN[22], TIEEMAC0UNICASTADDR[22]);
buf B_TIEEMAC0UNICASTADDR23 (TIEEMAC0UNICASTADDR_IN[23], TIEEMAC0UNICASTADDR[23]);
buf B_TIEEMAC0UNICASTADDR24 (TIEEMAC0UNICASTADDR_IN[24], TIEEMAC0UNICASTADDR[24]);
buf B_TIEEMAC0UNICASTADDR25 (TIEEMAC0UNICASTADDR_IN[25], TIEEMAC0UNICASTADDR[25]);
buf B_TIEEMAC0UNICASTADDR26 (TIEEMAC0UNICASTADDR_IN[26], TIEEMAC0UNICASTADDR[26]);
buf B_TIEEMAC0UNICASTADDR27 (TIEEMAC0UNICASTADDR_IN[27], TIEEMAC0UNICASTADDR[27]);
buf B_TIEEMAC0UNICASTADDR28 (TIEEMAC0UNICASTADDR_IN[28], TIEEMAC0UNICASTADDR[28]);
buf B_TIEEMAC0UNICASTADDR29 (TIEEMAC0UNICASTADDR_IN[29], TIEEMAC0UNICASTADDR[29]);
buf B_TIEEMAC0UNICASTADDR30 (TIEEMAC0UNICASTADDR_IN[30], TIEEMAC0UNICASTADDR[30]);
buf B_TIEEMAC0UNICASTADDR31 (TIEEMAC0UNICASTADDR_IN[31], TIEEMAC0UNICASTADDR[31]);
buf B_TIEEMAC0UNICASTADDR32 (TIEEMAC0UNICASTADDR_IN[32], TIEEMAC0UNICASTADDR[32]);
buf B_TIEEMAC0UNICASTADDR33 (TIEEMAC0UNICASTADDR_IN[33], TIEEMAC0UNICASTADDR[33]);
buf B_TIEEMAC0UNICASTADDR34 (TIEEMAC0UNICASTADDR_IN[34], TIEEMAC0UNICASTADDR[34]);
buf B_TIEEMAC0UNICASTADDR35 (TIEEMAC0UNICASTADDR_IN[35], TIEEMAC0UNICASTADDR[35]);
buf B_TIEEMAC0UNICASTADDR36 (TIEEMAC0UNICASTADDR_IN[36], TIEEMAC0UNICASTADDR[36]);
buf B_TIEEMAC0UNICASTADDR37 (TIEEMAC0UNICASTADDR_IN[37], TIEEMAC0UNICASTADDR[37]);
buf B_TIEEMAC0UNICASTADDR38 (TIEEMAC0UNICASTADDR_IN[38], TIEEMAC0UNICASTADDR[38]);
buf B_TIEEMAC0UNICASTADDR39 (TIEEMAC0UNICASTADDR_IN[39], TIEEMAC0UNICASTADDR[39]);
buf B_TIEEMAC0UNICASTADDR40 (TIEEMAC0UNICASTADDR_IN[40], TIEEMAC0UNICASTADDR[40]);
buf B_TIEEMAC0UNICASTADDR41 (TIEEMAC0UNICASTADDR_IN[41], TIEEMAC0UNICASTADDR[41]);
buf B_TIEEMAC0UNICASTADDR42 (TIEEMAC0UNICASTADDR_IN[42], TIEEMAC0UNICASTADDR[42]);
buf B_TIEEMAC0UNICASTADDR43 (TIEEMAC0UNICASTADDR_IN[43], TIEEMAC0UNICASTADDR[43]);
buf B_TIEEMAC0UNICASTADDR44 (TIEEMAC0UNICASTADDR_IN[44], TIEEMAC0UNICASTADDR[44]);
buf B_TIEEMAC0UNICASTADDR45 (TIEEMAC0UNICASTADDR_IN[45], TIEEMAC0UNICASTADDR[45]);
buf B_TIEEMAC0UNICASTADDR46 (TIEEMAC0UNICASTADDR_IN[46], TIEEMAC0UNICASTADDR[46]);
buf B_TIEEMAC0UNICASTADDR47 (TIEEMAC0UNICASTADDR_IN[47], TIEEMAC0UNICASTADDR[47]);
buf B_TIEEMAC1CONFIGVEC0 (TIEEMAC1CONFIGVEC_IN[0], TIEEMAC1CONFIGVEC[0]);
buf B_TIEEMAC1CONFIGVEC1 (TIEEMAC1CONFIGVEC_IN[1], TIEEMAC1CONFIGVEC[1]);
buf B_TIEEMAC1CONFIGVEC2 (TIEEMAC1CONFIGVEC_IN[2], TIEEMAC1CONFIGVEC[2]);
buf B_TIEEMAC1CONFIGVEC3 (TIEEMAC1CONFIGVEC_IN[3], TIEEMAC1CONFIGVEC[3]);
buf B_TIEEMAC1CONFIGVEC4 (TIEEMAC1CONFIGVEC_IN[4], TIEEMAC1CONFIGVEC[4]);
buf B_TIEEMAC1CONFIGVEC5 (TIEEMAC1CONFIGVEC_IN[5], TIEEMAC1CONFIGVEC[5]);
buf B_TIEEMAC1CONFIGVEC6 (TIEEMAC1CONFIGVEC_IN[6], TIEEMAC1CONFIGVEC[6]);
buf B_TIEEMAC1CONFIGVEC7 (TIEEMAC1CONFIGVEC_IN[7], TIEEMAC1CONFIGVEC[7]);
buf B_TIEEMAC1CONFIGVEC8 (TIEEMAC1CONFIGVEC_IN[8], TIEEMAC1CONFIGVEC[8]);
buf B_TIEEMAC1CONFIGVEC9 (TIEEMAC1CONFIGVEC_IN[9], TIEEMAC1CONFIGVEC[9]);
buf B_TIEEMAC1CONFIGVEC10 (TIEEMAC1CONFIGVEC_IN[10], TIEEMAC1CONFIGVEC[10]);
buf B_TIEEMAC1CONFIGVEC11 (TIEEMAC1CONFIGVEC_IN[11], TIEEMAC1CONFIGVEC[11]);
buf B_TIEEMAC1CONFIGVEC12 (TIEEMAC1CONFIGVEC_IN[12], TIEEMAC1CONFIGVEC[12]);
buf B_TIEEMAC1CONFIGVEC13 (TIEEMAC1CONFIGVEC_IN[13], TIEEMAC1CONFIGVEC[13]);
buf B_TIEEMAC1CONFIGVEC14 (TIEEMAC1CONFIGVEC_IN[14], TIEEMAC1CONFIGVEC[14]);
buf B_TIEEMAC1CONFIGVEC15 (TIEEMAC1CONFIGVEC_IN[15], TIEEMAC1CONFIGVEC[15]);
buf B_TIEEMAC1CONFIGVEC16 (TIEEMAC1CONFIGVEC_IN[16], TIEEMAC1CONFIGVEC[16]);
buf B_TIEEMAC1CONFIGVEC17 (TIEEMAC1CONFIGVEC_IN[17], TIEEMAC1CONFIGVEC[17]);
buf B_TIEEMAC1CONFIGVEC18 (TIEEMAC1CONFIGVEC_IN[18], TIEEMAC1CONFIGVEC[18]);
buf B_TIEEMAC1CONFIGVEC19 (TIEEMAC1CONFIGVEC_IN[19], TIEEMAC1CONFIGVEC[19]);
buf B_TIEEMAC1CONFIGVEC20 (TIEEMAC1CONFIGVEC_IN[20], TIEEMAC1CONFIGVEC[20]);
buf B_TIEEMAC1CONFIGVEC21 (TIEEMAC1CONFIGVEC_IN[21], TIEEMAC1CONFIGVEC[21]);
buf B_TIEEMAC1CONFIGVEC22 (TIEEMAC1CONFIGVEC_IN[22], TIEEMAC1CONFIGVEC[22]);
buf B_TIEEMAC1CONFIGVEC23 (TIEEMAC1CONFIGVEC_IN[23], TIEEMAC1CONFIGVEC[23]);
buf B_TIEEMAC1CONFIGVEC24 (TIEEMAC1CONFIGVEC_IN[24], TIEEMAC1CONFIGVEC[24]);
buf B_TIEEMAC1CONFIGVEC25 (TIEEMAC1CONFIGVEC_IN[25], TIEEMAC1CONFIGVEC[25]);
buf B_TIEEMAC1CONFIGVEC26 (TIEEMAC1CONFIGVEC_IN[26], TIEEMAC1CONFIGVEC[26]);
buf B_TIEEMAC1CONFIGVEC27 (TIEEMAC1CONFIGVEC_IN[27], TIEEMAC1CONFIGVEC[27]);
buf B_TIEEMAC1CONFIGVEC28 (TIEEMAC1CONFIGVEC_IN[28], TIEEMAC1CONFIGVEC[28]);
buf B_TIEEMAC1CONFIGVEC29 (TIEEMAC1CONFIGVEC_IN[29], TIEEMAC1CONFIGVEC[29]);
buf B_TIEEMAC1CONFIGVEC30 (TIEEMAC1CONFIGVEC_IN[30], TIEEMAC1CONFIGVEC[30]);
buf B_TIEEMAC1CONFIGVEC31 (TIEEMAC1CONFIGVEC_IN[31], TIEEMAC1CONFIGVEC[31]);
buf B_TIEEMAC1CONFIGVEC32 (TIEEMAC1CONFIGVEC_IN[32], TIEEMAC1CONFIGVEC[32]);
buf B_TIEEMAC1CONFIGVEC33 (TIEEMAC1CONFIGVEC_IN[33], TIEEMAC1CONFIGVEC[33]);
buf B_TIEEMAC1CONFIGVEC34 (TIEEMAC1CONFIGVEC_IN[34], TIEEMAC1CONFIGVEC[34]);
buf B_TIEEMAC1CONFIGVEC35 (TIEEMAC1CONFIGVEC_IN[35], TIEEMAC1CONFIGVEC[35]);
buf B_TIEEMAC1CONFIGVEC36 (TIEEMAC1CONFIGVEC_IN[36], TIEEMAC1CONFIGVEC[36]);
buf B_TIEEMAC1CONFIGVEC37 (TIEEMAC1CONFIGVEC_IN[37], TIEEMAC1CONFIGVEC[37]);
buf B_TIEEMAC1CONFIGVEC38 (TIEEMAC1CONFIGVEC_IN[38], TIEEMAC1CONFIGVEC[38]);
buf B_TIEEMAC1CONFIGVEC39 (TIEEMAC1CONFIGVEC_IN[39], TIEEMAC1CONFIGVEC[39]);
buf B_TIEEMAC1CONFIGVEC40 (TIEEMAC1CONFIGVEC_IN[40], TIEEMAC1CONFIGVEC[40]);
buf B_TIEEMAC1CONFIGVEC41 (TIEEMAC1CONFIGVEC_IN[41], TIEEMAC1CONFIGVEC[41]);
buf B_TIEEMAC1CONFIGVEC42 (TIEEMAC1CONFIGVEC_IN[42], TIEEMAC1CONFIGVEC[42]);
buf B_TIEEMAC1CONFIGVEC43 (TIEEMAC1CONFIGVEC_IN[43], TIEEMAC1CONFIGVEC[43]);
buf B_TIEEMAC1CONFIGVEC44 (TIEEMAC1CONFIGVEC_IN[44], TIEEMAC1CONFIGVEC[44]);
buf B_TIEEMAC1CONFIGVEC45 (TIEEMAC1CONFIGVEC_IN[45], TIEEMAC1CONFIGVEC[45]);
buf B_TIEEMAC1CONFIGVEC46 (TIEEMAC1CONFIGVEC_IN[46], TIEEMAC1CONFIGVEC[46]);
buf B_TIEEMAC1CONFIGVEC47 (TIEEMAC1CONFIGVEC_IN[47], TIEEMAC1CONFIGVEC[47]);
buf B_TIEEMAC1CONFIGVEC48 (TIEEMAC1CONFIGVEC_IN[48], TIEEMAC1CONFIGVEC[48]);
buf B_TIEEMAC1CONFIGVEC49 (TIEEMAC1CONFIGVEC_IN[49], TIEEMAC1CONFIGVEC[49]);
buf B_TIEEMAC1CONFIGVEC50 (TIEEMAC1CONFIGVEC_IN[50], TIEEMAC1CONFIGVEC[50]);
buf B_TIEEMAC1CONFIGVEC51 (TIEEMAC1CONFIGVEC_IN[51], TIEEMAC1CONFIGVEC[51]);
buf B_TIEEMAC1CONFIGVEC52 (TIEEMAC1CONFIGVEC_IN[52], TIEEMAC1CONFIGVEC[52]);
buf B_TIEEMAC1CONFIGVEC53 (TIEEMAC1CONFIGVEC_IN[53], TIEEMAC1CONFIGVEC[53]);
buf B_TIEEMAC1CONFIGVEC54 (TIEEMAC1CONFIGVEC_IN[54], TIEEMAC1CONFIGVEC[54]);
buf B_TIEEMAC1CONFIGVEC55 (TIEEMAC1CONFIGVEC_IN[55], TIEEMAC1CONFIGVEC[55]);
buf B_TIEEMAC1CONFIGVEC56 (TIEEMAC1CONFIGVEC_IN[56], TIEEMAC1CONFIGVEC[56]);
buf B_TIEEMAC1CONFIGVEC57 (TIEEMAC1CONFIGVEC_IN[57], TIEEMAC1CONFIGVEC[57]);
buf B_TIEEMAC1CONFIGVEC58 (TIEEMAC1CONFIGVEC_IN[58], TIEEMAC1CONFIGVEC[58]);
buf B_TIEEMAC1CONFIGVEC59 (TIEEMAC1CONFIGVEC_IN[59], TIEEMAC1CONFIGVEC[59]);
buf B_TIEEMAC1CONFIGVEC60 (TIEEMAC1CONFIGVEC_IN[60], TIEEMAC1CONFIGVEC[60]);
buf B_TIEEMAC1CONFIGVEC61 (TIEEMAC1CONFIGVEC_IN[61], TIEEMAC1CONFIGVEC[61]);
buf B_TIEEMAC1CONFIGVEC62 (TIEEMAC1CONFIGVEC_IN[62], TIEEMAC1CONFIGVEC[62]);
buf B_TIEEMAC1CONFIGVEC63 (TIEEMAC1CONFIGVEC_IN[63], TIEEMAC1CONFIGVEC[63]);
buf B_TIEEMAC1CONFIGVEC64 (TIEEMAC1CONFIGVEC_IN[64], TIEEMAC1CONFIGVEC[64]);
buf B_TIEEMAC1CONFIGVEC65 (TIEEMAC1CONFIGVEC_IN[65], TIEEMAC1CONFIGVEC[65]);
buf B_TIEEMAC1CONFIGVEC66 (TIEEMAC1CONFIGVEC_IN[66], TIEEMAC1CONFIGVEC[66]);
buf B_TIEEMAC1CONFIGVEC67 (TIEEMAC1CONFIGVEC_IN[67], TIEEMAC1CONFIGVEC[67]);
buf B_TIEEMAC1CONFIGVEC68 (TIEEMAC1CONFIGVEC_IN[68], TIEEMAC1CONFIGVEC[68]);
buf B_TIEEMAC1CONFIGVEC69 (TIEEMAC1CONFIGVEC_IN[69], TIEEMAC1CONFIGVEC[69]);
buf B_TIEEMAC1CONFIGVEC70 (TIEEMAC1CONFIGVEC_IN[70], TIEEMAC1CONFIGVEC[70]);
buf B_TIEEMAC1CONFIGVEC71 (TIEEMAC1CONFIGVEC_IN[71], TIEEMAC1CONFIGVEC[71]);
buf B_TIEEMAC1CONFIGVEC72 (TIEEMAC1CONFIGVEC_IN[72], TIEEMAC1CONFIGVEC[72]);
buf B_TIEEMAC1CONFIGVEC73 (TIEEMAC1CONFIGVEC_IN[73], TIEEMAC1CONFIGVEC[73]);
buf B_TIEEMAC1CONFIGVEC74 (TIEEMAC1CONFIGVEC_IN[74], TIEEMAC1CONFIGVEC[74]);
buf B_TIEEMAC1CONFIGVEC75 (TIEEMAC1CONFIGVEC_IN[75], TIEEMAC1CONFIGVEC[75]);
buf B_TIEEMAC1CONFIGVEC76 (TIEEMAC1CONFIGVEC_IN[76], TIEEMAC1CONFIGVEC[76]);
buf B_TIEEMAC1CONFIGVEC77 (TIEEMAC1CONFIGVEC_IN[77], TIEEMAC1CONFIGVEC[77]);
buf B_TIEEMAC1CONFIGVEC78 (TIEEMAC1CONFIGVEC_IN[78], TIEEMAC1CONFIGVEC[78]);
buf B_TIEEMAC1CONFIGVEC79 (TIEEMAC1CONFIGVEC_IN[79], TIEEMAC1CONFIGVEC[79]);
buf B_TIEEMAC1UNICASTADDR0 (TIEEMAC1UNICASTADDR_IN[0], TIEEMAC1UNICASTADDR[0]);
buf B_TIEEMAC1UNICASTADDR1 (TIEEMAC1UNICASTADDR_IN[1], TIEEMAC1UNICASTADDR[1]);
buf B_TIEEMAC1UNICASTADDR2 (TIEEMAC1UNICASTADDR_IN[2], TIEEMAC1UNICASTADDR[2]);
buf B_TIEEMAC1UNICASTADDR3 (TIEEMAC1UNICASTADDR_IN[3], TIEEMAC1UNICASTADDR[3]);
buf B_TIEEMAC1UNICASTADDR4 (TIEEMAC1UNICASTADDR_IN[4], TIEEMAC1UNICASTADDR[4]);
buf B_TIEEMAC1UNICASTADDR5 (TIEEMAC1UNICASTADDR_IN[5], TIEEMAC1UNICASTADDR[5]);
buf B_TIEEMAC1UNICASTADDR6 (TIEEMAC1UNICASTADDR_IN[6], TIEEMAC1UNICASTADDR[6]);
buf B_TIEEMAC1UNICASTADDR7 (TIEEMAC1UNICASTADDR_IN[7], TIEEMAC1UNICASTADDR[7]);
buf B_TIEEMAC1UNICASTADDR8 (TIEEMAC1UNICASTADDR_IN[8], TIEEMAC1UNICASTADDR[8]);
buf B_TIEEMAC1UNICASTADDR9 (TIEEMAC1UNICASTADDR_IN[9], TIEEMAC1UNICASTADDR[9]);
buf B_TIEEMAC1UNICASTADDR10 (TIEEMAC1UNICASTADDR_IN[10], TIEEMAC1UNICASTADDR[10]);
buf B_TIEEMAC1UNICASTADDR11 (TIEEMAC1UNICASTADDR_IN[11], TIEEMAC1UNICASTADDR[11]);
buf B_TIEEMAC1UNICASTADDR12 (TIEEMAC1UNICASTADDR_IN[12], TIEEMAC1UNICASTADDR[12]);
buf B_TIEEMAC1UNICASTADDR13 (TIEEMAC1UNICASTADDR_IN[13], TIEEMAC1UNICASTADDR[13]);
buf B_TIEEMAC1UNICASTADDR14 (TIEEMAC1UNICASTADDR_IN[14], TIEEMAC1UNICASTADDR[14]);
buf B_TIEEMAC1UNICASTADDR15 (TIEEMAC1UNICASTADDR_IN[15], TIEEMAC1UNICASTADDR[15]);
buf B_TIEEMAC1UNICASTADDR16 (TIEEMAC1UNICASTADDR_IN[16], TIEEMAC1UNICASTADDR[16]);
buf B_TIEEMAC1UNICASTADDR17 (TIEEMAC1UNICASTADDR_IN[17], TIEEMAC1UNICASTADDR[17]);
buf B_TIEEMAC1UNICASTADDR18 (TIEEMAC1UNICASTADDR_IN[18], TIEEMAC1UNICASTADDR[18]);
buf B_TIEEMAC1UNICASTADDR19 (TIEEMAC1UNICASTADDR_IN[19], TIEEMAC1UNICASTADDR[19]);
buf B_TIEEMAC1UNICASTADDR20 (TIEEMAC1UNICASTADDR_IN[20], TIEEMAC1UNICASTADDR[20]);
buf B_TIEEMAC1UNICASTADDR21 (TIEEMAC1UNICASTADDR_IN[21], TIEEMAC1UNICASTADDR[21]);
buf B_TIEEMAC1UNICASTADDR22 (TIEEMAC1UNICASTADDR_IN[22], TIEEMAC1UNICASTADDR[22]);
buf B_TIEEMAC1UNICASTADDR23 (TIEEMAC1UNICASTADDR_IN[23], TIEEMAC1UNICASTADDR[23]);
buf B_TIEEMAC1UNICASTADDR24 (TIEEMAC1UNICASTADDR_IN[24], TIEEMAC1UNICASTADDR[24]);
buf B_TIEEMAC1UNICASTADDR25 (TIEEMAC1UNICASTADDR_IN[25], TIEEMAC1UNICASTADDR[25]);
buf B_TIEEMAC1UNICASTADDR26 (TIEEMAC1UNICASTADDR_IN[26], TIEEMAC1UNICASTADDR[26]);
buf B_TIEEMAC1UNICASTADDR27 (TIEEMAC1UNICASTADDR_IN[27], TIEEMAC1UNICASTADDR[27]);
buf B_TIEEMAC1UNICASTADDR28 (TIEEMAC1UNICASTADDR_IN[28], TIEEMAC1UNICASTADDR[28]);
buf B_TIEEMAC1UNICASTADDR29 (TIEEMAC1UNICASTADDR_IN[29], TIEEMAC1UNICASTADDR[29]);
buf B_TIEEMAC1UNICASTADDR30 (TIEEMAC1UNICASTADDR_IN[30], TIEEMAC1UNICASTADDR[30]);
buf B_TIEEMAC1UNICASTADDR31 (TIEEMAC1UNICASTADDR_IN[31], TIEEMAC1UNICASTADDR[31]);
buf B_TIEEMAC1UNICASTADDR32 (TIEEMAC1UNICASTADDR_IN[32], TIEEMAC1UNICASTADDR[32]);
buf B_TIEEMAC1UNICASTADDR33 (TIEEMAC1UNICASTADDR_IN[33], TIEEMAC1UNICASTADDR[33]);
buf B_TIEEMAC1UNICASTADDR34 (TIEEMAC1UNICASTADDR_IN[34], TIEEMAC1UNICASTADDR[34]);
buf B_TIEEMAC1UNICASTADDR35 (TIEEMAC1UNICASTADDR_IN[35], TIEEMAC1UNICASTADDR[35]);
buf B_TIEEMAC1UNICASTADDR36 (TIEEMAC1UNICASTADDR_IN[36], TIEEMAC1UNICASTADDR[36]);
buf B_TIEEMAC1UNICASTADDR37 (TIEEMAC1UNICASTADDR_IN[37], TIEEMAC1UNICASTADDR[37]);
buf B_TIEEMAC1UNICASTADDR38 (TIEEMAC1UNICASTADDR_IN[38], TIEEMAC1UNICASTADDR[38]);
buf B_TIEEMAC1UNICASTADDR39 (TIEEMAC1UNICASTADDR_IN[39], TIEEMAC1UNICASTADDR[39]);
buf B_TIEEMAC1UNICASTADDR40 (TIEEMAC1UNICASTADDR_IN[40], TIEEMAC1UNICASTADDR[40]);
buf B_TIEEMAC1UNICASTADDR41 (TIEEMAC1UNICASTADDR_IN[41], TIEEMAC1UNICASTADDR[41]);
buf B_TIEEMAC1UNICASTADDR42 (TIEEMAC1UNICASTADDR_IN[42], TIEEMAC1UNICASTADDR[42]);
buf B_TIEEMAC1UNICASTADDR43 (TIEEMAC1UNICASTADDR_IN[43], TIEEMAC1UNICASTADDR[43]);
buf B_TIEEMAC1UNICASTADDR44 (TIEEMAC1UNICASTADDR_IN[44], TIEEMAC1UNICASTADDR[44]);
buf B_TIEEMAC1UNICASTADDR45 (TIEEMAC1UNICASTADDR_IN[45], TIEEMAC1UNICASTADDR[45]);
buf B_TIEEMAC1UNICASTADDR46 (TIEEMAC1UNICASTADDR_IN[46], TIEEMAC1UNICASTADDR[46]);
buf B_TIEEMAC1UNICASTADDR47 (TIEEMAC1UNICASTADDR_IN[47], TIEEMAC1UNICASTADDR[47]);
buf B_DCREMACWRITE (DCREMACWRITE_IN, DCREMACWRITE);
buf B_DCREMACREAD (DCREMACREAD_IN, DCREMACREAD);
buf B_DCREMACCLK (DCREMACCLK_IN, DCREMACCLK);

localparam client_in_delay = 125;
localparam miitxclk_delay = 125;

/*Delay EMAC# client input signals in 16-bit client mode*/
// EMAC0
assign #(client_in_delay) CLIENTEMAC0TXD_delay = CLIENTEMAC0TXD_IN;
assign #(client_in_delay) CLIENTEMAC0TXDVLD_delay = CLIENTEMAC0TXDVLD_IN;
assign #(client_in_delay) CLIENTEMAC0TXDVLDMSW_delay = CLIENTEMAC0TXDVLDMSW_IN;

assign CLIENTEMAC0TXD_client16_delay       = (TIEEMAC0CONFIGVEC[66] == 1'b1) ? CLIENTEMAC0TXD_delay : CLIENTEMAC0TXD_IN;        // CONFIGVEC[66] is 16-bit Tx client
assign CLIENTEMAC0TXDVLD_client16_delay    = (TIEEMAC0CONFIGVEC[66] == 1'b1) ? CLIENTEMAC0TXDVLD_delay : CLIENTEMAC0TXDVLD_IN;
assign CLIENTEMAC0TXDVLDMSW_client16_delay = (TIEEMAC0CONFIGVEC[66] == 1'b1) ? CLIENTEMAC0TXDVLDMSW_delay : CLIENTEMAC0TXDVLDMSW_IN;

// EMAC1
assign #(client_in_delay) CLIENTEMAC1TXD_delay = CLIENTEMAC1TXD_IN;
assign #(client_in_delay) CLIENTEMAC1TXDVLD_delay = CLIENTEMAC1TXDVLD_IN;
assign #(client_in_delay) CLIENTEMAC1TXDVLDMSW_delay = CLIENTEMAC1TXDVLDMSW_IN;

assign CLIENTEMAC1TXD_client16_delay       = (TIEEMAC1CONFIGVEC[66] == 1'b1) ? CLIENTEMAC1TXD_delay : CLIENTEMAC1TXD_IN;        // CONFIGVEC[66] is 16-bit Tx client
assign CLIENTEMAC1TXDVLD_client16_delay    = (TIEEMAC1CONFIGVEC[66] == 1'b1) ? CLIENTEMAC1TXDVLD_delay : CLIENTEMAC1TXDVLD_IN;
assign CLIENTEMAC1TXDVLDMSW_client16_delay = (TIEEMAC1CONFIGVEC[66] == 1'b1) ? CLIENTEMAC1TXDVLDMSW_delay : CLIENTEMAC1TXDVLDMSW_IN;

/*Skew 125 MHz clock EMAC#MIITXCLK against 250 MHz clock in 16-bit client mode*/
assign #(miitxclk_delay) PHYEMAC0MIITXCLK_delay = PHYEMAC0MIITXCLK_IN;
assign PHYEMAC0MIITXCLK_skewed = (TIEEMAC0CONFIGVEC[66] == 1'b1) ? PHYEMAC0MIITXCLK_delay : PHYEMAC0MIITXCLK_IN; // In TXCLIENT16 mode

assign #(miitxclk_delay) PHYEMAC1MIITXCLK_delay = PHYEMAC1MIITXCLK_IN;
assign PHYEMAC1MIITXCLK_skewed = (TIEEMAC1CONFIGVEC[66] == 1'b1) ? PHYEMAC1MIITXCLK_delay : PHYEMAC1MIITXCLK_IN; // In TXCLIENT16 mode
wire dcremacclk_delay;
assign #10 dcremacclk_delay = DCREMACCLK_IN;

EMAC_SWIFT emac_swift_1 (
	.CLIENTEMAC0DCMLOCKED (CLIENTEMAC0DCMLOCKED_IN),
	.CLIENTEMAC0PAUSEREQ (CLIENTEMAC0PAUSEREQ_IN),
	.CLIENTEMAC0PAUSEVAL (CLIENTEMAC0PAUSEVAL_IN),
	.CLIENTEMAC0RXCLIENTCLKIN (CLIENTEMAC0RXCLIENTCLKIN_IN),
	.CLIENTEMAC0TXCLIENTCLKIN (CLIENTEMAC0TXCLIENTCLKIN_IN),
	.CLIENTEMAC0TXD (CLIENTEMAC0TXD_client16_delay),
	.CLIENTEMAC0TXDVLD (CLIENTEMAC0TXDVLD_client16_delay),
	.CLIENTEMAC0TXDVLDMSW (CLIENTEMAC0TXDVLDMSW_client16_delay),
	.CLIENTEMAC0TXFIRSTBYTE (CLIENTEMAC0TXFIRSTBYTE_IN),
	.CLIENTEMAC0TXGMIIMIICLKIN (CLIENTEMAC0TXGMIIMIICLKIN_IN),
	.CLIENTEMAC0TXIFGDELAY (CLIENTEMAC0TXIFGDELAY_IN),
	.CLIENTEMAC0TXUNDERRUN (CLIENTEMAC0TXUNDERRUN_IN),
	.CLIENTEMAC1DCMLOCKED (CLIENTEMAC1DCMLOCKED_IN),
	.CLIENTEMAC1PAUSEREQ (CLIENTEMAC1PAUSEREQ_IN),
	.CLIENTEMAC1PAUSEVAL (CLIENTEMAC1PAUSEVAL_IN),
	.CLIENTEMAC1RXCLIENTCLKIN (CLIENTEMAC1RXCLIENTCLKIN_IN),
	.CLIENTEMAC1TXCLIENTCLKIN (CLIENTEMAC1TXCLIENTCLKIN_IN),
	.CLIENTEMAC1TXD (CLIENTEMAC1TXD_client16_delay),
	.CLIENTEMAC1TXDVLD (CLIENTEMAC1TXDVLD_client16_delay),
	.CLIENTEMAC1TXDVLDMSW (CLIENTEMAC1TXDVLDMSW_client16_delay),
	.CLIENTEMAC1TXFIRSTBYTE (CLIENTEMAC1TXFIRSTBYTE_IN),
	.CLIENTEMAC1TXGMIIMIICLKIN (CLIENTEMAC1TXGMIIMIICLKIN_IN),
	.CLIENTEMAC1TXIFGDELAY (CLIENTEMAC1TXIFGDELAY_IN),
	.CLIENTEMAC1TXUNDERRUN (CLIENTEMAC1TXUNDERRUN_IN),
	.DCREMACABUS (DCREMACABUS_IN),
	.DCREMACCLK (dcremacclk_delay),
	.DCREMACDBUS (DCREMACDBUS_IN),
	.DCREMACENABLE (DCREMACENABLE_IN),
	.DCREMACREAD (DCREMACREAD_IN),
	.DCREMACWRITE (DCREMACWRITE_IN),
	.DCRHOSTDONEIR (DCRHOSTDONEIR_OUT),
	.EMAC0CLIENTANINTERRUPT (EMAC0CLIENTANINTERRUPT_OUT),
	.EMAC0CLIENTRXBADFRAME (EMAC0CLIENTRXBADFRAME_OUT),
	.EMAC0CLIENTRXCLIENTCLKOUT (EMAC0CLIENTRXCLIENTCLKOUT_OUT),
	.EMAC0CLIENTRXD (EMAC0CLIENTRXD_OUT),
	.EMAC0CLIENTRXDVLD (EMAC0CLIENTRXDVLD_OUT),
	.EMAC0CLIENTRXDVLDMSW (EMAC0CLIENTRXDVLDMSW_OUT),
	.EMAC0CLIENTRXDVREG6 (EMAC0CLIENTRXDVREG6_OUT),
	.EMAC0CLIENTRXFRAMEDROP (EMAC0CLIENTRXFRAMEDROP_OUT),
	.EMAC0CLIENTRXGOODFRAME (EMAC0CLIENTRXGOODFRAME_OUT),
	.EMAC0CLIENTRXSTATS (EMAC0CLIENTRXSTATS_OUT),
	.EMAC0CLIENTRXSTATSBYTEVLD (EMAC0CLIENTRXSTATSBYTEVLD_OUT),
	.EMAC0CLIENTRXSTATSVLD (EMAC0CLIENTRXSTATSVLD_OUT),
	.EMAC0CLIENTTXACK (EMAC0CLIENTTXACK_OUT),
	.EMAC0CLIENTTXCLIENTCLKOUT (EMAC0CLIENTTXCLIENTCLKOUT_OUT),
	.EMAC0CLIENTTXCOLLISION (EMAC0CLIENTTXCOLLISION_OUT),
	.EMAC0CLIENTTXGMIIMIICLKOUT (EMAC0CLIENTTXGMIIMIICLKOUT_OUT),
	.EMAC0CLIENTTXRETRANSMIT (EMAC0CLIENTTXRETRANSMIT_OUT),
	.EMAC0CLIENTTXSTATS (EMAC0CLIENTTXSTATS_OUT),
	.EMAC0CLIENTTXSTATSBYTEVLD (EMAC0CLIENTTXSTATSBYTEVLD_OUT),
	.EMAC0CLIENTTXSTATSVLD (EMAC0CLIENTTXSTATSVLD_OUT),
	.EMAC0PHYENCOMMAALIGN (EMAC0PHYENCOMMAALIGN_OUT),
	.EMAC0PHYLOOPBACKMSB (EMAC0PHYLOOPBACKMSB_OUT),
	.EMAC0PHYMCLKOUT (EMAC0PHYMCLKOUT_OUT),
	.EMAC0PHYMDOUT (EMAC0PHYMDOUT_OUT),
	.EMAC0PHYMDTRI (EMAC0PHYMDTRI_OUT),
	.EMAC0PHYMGTRXRESET (EMAC0PHYMGTRXRESET_OUT),
	.EMAC0PHYMGTTXRESET (EMAC0PHYMGTTXRESET_OUT),
	.EMAC0PHYPOWERDOWN (EMAC0PHYPOWERDOWN_OUT),
	.EMAC0PHYSYNCACQSTATUS (EMAC0PHYSYNCACQSTATUS_OUT),
	.EMAC0PHYTXCHARDISPMODE (EMAC0PHYTXCHARDISPMODE_OUT),
	.EMAC0PHYTXCHARDISPVAL (EMAC0PHYTXCHARDISPVAL_OUT),
	.EMAC0PHYTXCHARISK (EMAC0PHYTXCHARISK_OUT),
	.EMAC0PHYTXCLK (EMAC0PHYTXCLK_OUT),
	.EMAC0PHYTXD (EMAC0PHYTXD_OUT),
	.EMAC0PHYTXEN (EMAC0PHYTXEN_OUT),
	.EMAC0PHYTXER (EMAC0PHYTXER_OUT),
	.EMAC1CLIENTANINTERRUPT (EMAC1CLIENTANINTERRUPT_OUT),
	.EMAC1CLIENTRXBADFRAME (EMAC1CLIENTRXBADFRAME_OUT),
	.EMAC1CLIENTRXCLIENTCLKOUT (EMAC1CLIENTRXCLIENTCLKOUT_OUT),
	.EMAC1CLIENTRXD (EMAC1CLIENTRXD_OUT),
	.EMAC1CLIENTRXDVLD (EMAC1CLIENTRXDVLD_OUT),
	.EMAC1CLIENTRXDVLDMSW (EMAC1CLIENTRXDVLDMSW_OUT),
	.EMAC1CLIENTRXDVREG6 (EMAC1CLIENTRXDVREG6_OUT),
	.EMAC1CLIENTRXFRAMEDROP (EMAC1CLIENTRXFRAMEDROP_OUT),
	.EMAC1CLIENTRXGOODFRAME (EMAC1CLIENTRXGOODFRAME_OUT),
	.EMAC1CLIENTRXSTATS (EMAC1CLIENTRXSTATS_OUT),
	.EMAC1CLIENTRXSTATSBYTEVLD (EMAC1CLIENTRXSTATSBYTEVLD_OUT),
	.EMAC1CLIENTRXSTATSVLD (EMAC1CLIENTRXSTATSVLD_OUT),
	.EMAC1CLIENTTXACK (EMAC1CLIENTTXACK_OUT),
	.EMAC1CLIENTTXCLIENTCLKOUT (EMAC1CLIENTTXCLIENTCLKOUT_OUT),
	.EMAC1CLIENTTXCOLLISION (EMAC1CLIENTTXCOLLISION_OUT),
	.EMAC1CLIENTTXGMIIMIICLKOUT (EMAC1CLIENTTXGMIIMIICLKOUT_OUT),
	.EMAC1CLIENTTXRETRANSMIT (EMAC1CLIENTTXRETRANSMIT_OUT),
	.EMAC1CLIENTTXSTATS (EMAC1CLIENTTXSTATS_OUT),
	.EMAC1CLIENTTXSTATSBYTEVLD (EMAC1CLIENTTXSTATSBYTEVLD_OUT),
	.EMAC1CLIENTTXSTATSVLD (EMAC1CLIENTTXSTATSVLD_OUT),
	.EMAC1PHYENCOMMAALIGN (EMAC1PHYENCOMMAALIGN_OUT),
	.EMAC1PHYLOOPBACKMSB (EMAC1PHYLOOPBACKMSB_OUT),
	.EMAC1PHYMCLKOUT (EMAC1PHYMCLKOUT_OUT),
	.EMAC1PHYMDOUT (EMAC1PHYMDOUT_OUT),
	.EMAC1PHYMDTRI (EMAC1PHYMDTRI_OUT),
	.EMAC1PHYMGTRXRESET (EMAC1PHYMGTRXRESET_OUT),
	.EMAC1PHYMGTTXRESET (EMAC1PHYMGTTXRESET_OUT),
	.EMAC1PHYPOWERDOWN (EMAC1PHYPOWERDOWN_OUT),
	.EMAC1PHYSYNCACQSTATUS (EMAC1PHYSYNCACQSTATUS_OUT),
	.EMAC1PHYTXCHARDISPMODE (EMAC1PHYTXCHARDISPMODE_OUT),
	.EMAC1PHYTXCHARDISPVAL (EMAC1PHYTXCHARDISPVAL_OUT),
	.EMAC1PHYTXCHARISK (EMAC1PHYTXCHARISK_OUT),
	.EMAC1PHYTXCLK (EMAC1PHYTXCLK_OUT),
	.EMAC1PHYTXD (EMAC1PHYTXD_OUT),
	.EMAC1PHYTXEN (EMAC1PHYTXEN_OUT),
	.EMAC1PHYTXER (EMAC1PHYTXER_OUT),
	.EMACDCRACK (EMACDCRACK_OUT),
	.EMACDCRDBUS (EMACDCRDBUS_OUT),
	.HOSTADDR (HOSTADDR_IN),
	.HOSTCLK (HOSTCLK_IN),
	.HOSTEMAC1SEL (HOSTEMAC1SEL_IN),
	.HOSTMIIMRDY (HOSTMIIMRDY_OUT),
	.HOSTMIIMSEL (HOSTMIIMSEL_IN),
	.HOSTOPCODE (HOSTOPCODE_IN),
	.HOSTRDDATA (HOSTRDDATA_OUT),
	.HOSTREQ (HOSTREQ_IN),
	.HOSTWRDATA (HOSTWRDATA_IN),
	.PHYEMAC0COL (PHYEMAC0COL_IN),
	.PHYEMAC0CRS (PHYEMAC0CRS_IN),
	.PHYEMAC0GTXCLK (PHYEMAC0GTXCLK_IN),
	.PHYEMAC0MCLKIN (PHYEMAC0MCLKIN_IN),
	.PHYEMAC0MDIN (PHYEMAC0MDIN_IN),
	.PHYEMAC0MIITXCLK (PHYEMAC0MIITXCLK_skewed),
	.PHYEMAC0PHYAD (PHYEMAC0PHYAD_IN),
	.PHYEMAC0RXBUFERR (PHYEMAC0RXBUFERR_IN),
	.PHYEMAC0RXBUFSTATUS (PHYEMAC0RXBUFSTATUS_IN),
	.PHYEMAC0RXCHARISCOMMA (PHYEMAC0RXCHARISCOMMA_IN),
	.PHYEMAC0RXCHARISK (PHYEMAC0RXCHARISK_IN),
	.PHYEMAC0RXCHECKINGCRC (PHYEMAC0RXCHECKINGCRC_IN),
	.PHYEMAC0RXCLK (PHYEMAC0RXCLK_IN),
	.PHYEMAC0RXCLKCORCNT (PHYEMAC0RXCLKCORCNT_IN),
	.PHYEMAC0RXCOMMADET (PHYEMAC0RXCOMMADET_IN),
	.PHYEMAC0RXD (PHYEMAC0RXD_IN),
	.PHYEMAC0RXDISPERR (PHYEMAC0RXDISPERR_IN),
	.PHYEMAC0RXDV (PHYEMAC0RXDV_IN),
	.PHYEMAC0RXER (PHYEMAC0RXER_IN),
	.PHYEMAC0RXLOSSOFSYNC (PHYEMAC0RXLOSSOFSYNC_IN),
	.PHYEMAC0RXNOTINTABLE (PHYEMAC0RXNOTINTABLE_IN),
	.PHYEMAC0RXRUNDISP (PHYEMAC0RXRUNDISP_IN),
	.PHYEMAC0SIGNALDET (PHYEMAC0SIGNALDET_IN),
	.PHYEMAC0TXBUFERR (PHYEMAC0TXBUFERR_IN),
	.PHYEMAC1COL (PHYEMAC1COL_IN),
	.PHYEMAC1CRS (PHYEMAC1CRS_IN),
	.PHYEMAC1GTXCLK (PHYEMAC1GTXCLK_IN),
	.PHYEMAC1MCLKIN (PHYEMAC1MCLKIN_IN),
	.PHYEMAC1MDIN (PHYEMAC1MDIN_IN),
	.PHYEMAC1MIITXCLK (PHYEMAC1MIITXCLK_skewed),
	.PHYEMAC1PHYAD (PHYEMAC1PHYAD_IN),
	.PHYEMAC1RXBUFERR (PHYEMAC1RXBUFERR_IN),
	.PHYEMAC1RXBUFSTATUS (PHYEMAC1RXBUFSTATUS_IN),
	.PHYEMAC1RXCHARISCOMMA (PHYEMAC1RXCHARISCOMMA_IN),
	.PHYEMAC1RXCHARISK (PHYEMAC1RXCHARISK_IN),
	.PHYEMAC1RXCHECKINGCRC (PHYEMAC1RXCHECKINGCRC_IN),
	.PHYEMAC1RXCLK (PHYEMAC1RXCLK_IN),
	.PHYEMAC1RXCLKCORCNT (PHYEMAC1RXCLKCORCNT_IN),
	.PHYEMAC1RXCOMMADET (PHYEMAC1RXCOMMADET_IN),
	.PHYEMAC1RXD (PHYEMAC1RXD_IN),
	.PHYEMAC1RXDISPERR (PHYEMAC1RXDISPERR_IN),
	.PHYEMAC1RXDV (PHYEMAC1RXDV_IN),
	.PHYEMAC1RXER (PHYEMAC1RXER_IN),
	.PHYEMAC1RXLOSSOFSYNC (PHYEMAC1RXLOSSOFSYNC_IN),
	.PHYEMAC1RXNOTINTABLE (PHYEMAC1RXNOTINTABLE_IN),
	.PHYEMAC1RXRUNDISP (PHYEMAC1RXRUNDISP_IN),
	.PHYEMAC1SIGNALDET (PHYEMAC1SIGNALDET_IN),
	.PHYEMAC1TXBUFERR (PHYEMAC1TXBUFERR_IN),
	.RESET (RESET_IN),
	.TIEEMAC0CONFIGVEC (TIEEMAC0CONFIGVEC_IN),
	.TIEEMAC0UNICASTADDR (TIEEMAC0UNICASTADDR_IN),
	.TIEEMAC1CONFIGVEC (TIEEMAC1CONFIGVEC_IN),
	.TIEEMAC1UNICASTADDR (TIEEMAC1UNICASTADDR_IN)
);

specify
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXBADFRAME) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXDVLD) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXDVLDMSW) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXDVREG6) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[0]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[10]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[11]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[12]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[13]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[14]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[15]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[1]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[2]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[3]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[4]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[5]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[6]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[7]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[8]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXD[9]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXFRAMEDROP) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXGOODFRAME) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXSTATSBYTEVLD) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXSTATSVLD) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXSTATS[0]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXSTATS[1]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXSTATS[2]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXSTATS[3]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXSTATS[4]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXSTATS[5]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0RXCLIENTCLKIN => EMAC0CLIENTRXSTATS[6]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXCLIENTCLKIN => EMAC0CLIENTTXACK) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXCLIENTCLKIN => EMAC0CLIENTTXCOLLISION) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXCLIENTCLKIN => EMAC0CLIENTTXRETRANSMIT) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXCLIENTCLKIN => EMAC0CLIENTTXSTATS) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXCLIENTCLKIN => EMAC0CLIENTTXSTATSBYTEVLD) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXCLIENTCLKIN => EMAC0CLIENTTXSTATSVLD) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXGMIIMIICLKIN => EMAC0PHYTXD[0]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXGMIIMIICLKIN => EMAC0PHYTXD[1]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXGMIIMIICLKIN => EMAC0PHYTXD[2]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXGMIIMIICLKIN => EMAC0PHYTXD[3]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXGMIIMIICLKIN => EMAC0PHYTXD[4]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXGMIIMIICLKIN => EMAC0PHYTXD[5]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXGMIIMIICLKIN => EMAC0PHYTXD[6]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXGMIIMIICLKIN => EMAC0PHYTXD[7]) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXGMIIMIICLKIN => EMAC0PHYTXEN) = (100:100:100, 100:100:100);
	(CLIENTEMAC0TXGMIIMIICLKIN => EMAC0PHYTXER) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXBADFRAME) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXDVLD) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXDVLDMSW) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXDVREG6) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[0]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[10]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[11]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[12]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[13]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[14]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[15]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[1]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[2]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[3]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[4]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[5]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[6]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[7]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[8]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXD[9]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXFRAMEDROP) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXGOODFRAME) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXSTATSBYTEVLD) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXSTATSVLD) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXSTATS[0]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXSTATS[1]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXSTATS[2]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXSTATS[3]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXSTATS[4]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXSTATS[5]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1RXCLIENTCLKIN => EMAC1CLIENTRXSTATS[6]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXCLIENTCLKIN => EMAC1CLIENTTXACK) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXCLIENTCLKIN => EMAC1CLIENTTXCOLLISION) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXCLIENTCLKIN => EMAC1CLIENTTXRETRANSMIT) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXCLIENTCLKIN => EMAC1CLIENTTXSTATS) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXCLIENTCLKIN => EMAC1CLIENTTXSTATSBYTEVLD) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXCLIENTCLKIN => EMAC1CLIENTTXSTATSVLD) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXGMIIMIICLKIN => EMAC1PHYTXD[0]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXGMIIMIICLKIN => EMAC1PHYTXD[1]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXGMIIMIICLKIN => EMAC1PHYTXD[2]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXGMIIMIICLKIN => EMAC1PHYTXD[3]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXGMIIMIICLKIN => EMAC1PHYTXD[4]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXGMIIMIICLKIN => EMAC1PHYTXD[5]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXGMIIMIICLKIN => EMAC1PHYTXD[6]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXGMIIMIICLKIN => EMAC1PHYTXD[7]) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXGMIIMIICLKIN => EMAC1PHYTXEN) = (100:100:100, 100:100:100);
	(CLIENTEMAC1TXGMIIMIICLKIN => EMAC1PHYTXER) = (100:100:100, 100:100:100);
	(HOSTCLK => EMAC0PHYMCLKOUT) = (100:100:100, 100:100:100);
	(HOSTCLK => EMAC0PHYMDOUT) = (100:100:100, 100:100:100);
	(HOSTCLK => EMAC0PHYMDTRI) = (100:100:100, 100:100:100);
	(HOSTCLK => EMAC1PHYMCLKOUT) = (100:100:100, 100:100:100);
	(HOSTCLK => EMAC1PHYMDOUT) = (100:100:100, 100:100:100);
	(HOSTCLK => EMAC1PHYMDTRI) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTMIIMRDY) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[0]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[10]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[11]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[12]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[13]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[14]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[15]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[16]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[17]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[18]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[19]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[1]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[20]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[21]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[22]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[23]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[24]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[25]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[26]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[27]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[28]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[29]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[2]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[30]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[31]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[3]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[4]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[5]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[6]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[7]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[8]) = (100:100:100, 100:100:100);
	(HOSTCLK => HOSTRDDATA[9]) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0CLIENTANINTERRUPT) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0CLIENTRXCLIENTCLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0CLIENTTXCLIENTCLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0CLIENTTXGMIIMIICLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0PHYENCOMMAALIGN) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0PHYLOOPBACKMSB) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0PHYMGTRXRESET) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0PHYMGTTXRESET) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0PHYPOWERDOWN) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0PHYSYNCACQSTATUS) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0PHYTXCHARDISPMODE) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0PHYTXCHARDISPVAL) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0PHYTXCHARISK) = (100:100:100, 100:100:100);
	(PHYEMAC0GTXCLK => EMAC0PHYTXCLK) = (100:100:100, 100:100:100);
	(PHYEMAC0MCLKIN => EMAC0PHYMCLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC0MCLKIN => EMAC0PHYMDOUT) = (100:100:100, 100:100:100);
	(PHYEMAC0MCLKIN => EMAC0PHYMDTRI) = (100:100:100, 100:100:100);
	(PHYEMAC0MIITXCLK => EMAC0CLIENTTXCLIENTCLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC0MIITXCLK => EMAC0CLIENTTXGMIIMIICLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC0RXCLK => EMAC0CLIENTRXCLIENTCLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1CLIENTANINTERRUPT) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1CLIENTRXCLIENTCLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1CLIENTTXCLIENTCLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1CLIENTTXGMIIMIICLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1PHYENCOMMAALIGN) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1PHYLOOPBACKMSB) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1PHYMGTRXRESET) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1PHYMGTTXRESET) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1PHYPOWERDOWN) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1PHYSYNCACQSTATUS) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1PHYTXCHARDISPMODE) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1PHYTXCHARDISPVAL) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1PHYTXCHARISK) = (100:100:100, 100:100:100);
	(PHYEMAC1GTXCLK => EMAC1PHYTXCLK) = (100:100:100, 100:100:100);
	(PHYEMAC1MCLKIN => EMAC1PHYMCLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC1MCLKIN => EMAC1PHYMDOUT) = (100:100:100, 100:100:100);
	(PHYEMAC1MCLKIN => EMAC1PHYMDTRI) = (100:100:100, 100:100:100);
	(PHYEMAC1MIITXCLK => EMAC1CLIENTTXCLIENTCLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC1MIITXCLK => EMAC1CLIENTTXGMIIMIICLKOUT) = (100:100:100, 100:100:100);
	(PHYEMAC1RXCLK => EMAC1CLIENTRXCLIENTCLKOUT) = (100:100:100, 100:100:100);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEREQ, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[0], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[10], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[11], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[12], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[13], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[14], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[15], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[1], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[2], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[3], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[4], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[5], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[6], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[7], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[8], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0PAUSEVAL[9], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXDVLD, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXDVLDMSW, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[0], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[10], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[11], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[12], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[13], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[14], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[15], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[1], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[2], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[3], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[4], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[5], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[6], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[7], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[8], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXD[9], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXFIRSTBYTE, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXIFGDELAY[0], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXIFGDELAY[1], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXIFGDELAY[2], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXIFGDELAY[3], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXIFGDELAY[4], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXIFGDELAY[5], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXIFGDELAY[6], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXIFGDELAY[7], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, negedge CLIENTEMAC0TXUNDERRUN, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEREQ, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[0], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[10], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[11], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[12], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[13], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[14], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[15], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[1], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[2], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[3], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[4], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[5], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[6], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[7], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[8], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0PAUSEVAL[9], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXDVLD, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXDVLDMSW, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[0], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[10], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[11], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[12], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[13], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[14], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[15], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[1], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[2], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[3], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[4], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[5], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[6], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[7], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[8], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXD[9], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXFIRSTBYTE, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXIFGDELAY[0], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXIFGDELAY[1], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXIFGDELAY[2], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXIFGDELAY[3], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXIFGDELAY[4], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXIFGDELAY[5], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXIFGDELAY[6], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXIFGDELAY[7], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC0TXCLIENTCLKIN, posedge CLIENTEMAC0TXUNDERRUN, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEREQ, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[0], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[10], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[11], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[12], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[13], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[14], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[15], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[1], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[2], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[3], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[4], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[5], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[6], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[7], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[8], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1PAUSEVAL[9], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXDVLD, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXDVLDMSW, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[0], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[10], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[11], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[12], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[13], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[14], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[15], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[1], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[2], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[3], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[4], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[5], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[6], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[7], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[8], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXD[9], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXFIRSTBYTE, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXIFGDELAY[0], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXIFGDELAY[1], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXIFGDELAY[2], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXIFGDELAY[3], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXIFGDELAY[4], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXIFGDELAY[5], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXIFGDELAY[6], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXIFGDELAY[7], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, negedge CLIENTEMAC1TXUNDERRUN, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEREQ, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[0], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[10], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[11], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[12], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[13], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[14], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[15], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[1], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[2], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[3], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[4], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[5], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[6], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[7], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[8], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1PAUSEVAL[9], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXDVLD, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXDVLDMSW, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[0], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[10], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[11], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[12], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[13], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[14], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[15], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[1], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[2], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[3], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[4], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[5], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[6], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[7], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[8], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXD[9], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXFIRSTBYTE, 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXIFGDELAY[0], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXIFGDELAY[1], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXIFGDELAY[2], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXIFGDELAY[3], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXIFGDELAY[4], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXIFGDELAY[5], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXIFGDELAY[6], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXIFGDELAY[7], 0:0:0, 0:0:0);
	$setuphold (posedge CLIENTEMAC1TXCLIENTCLKIN, posedge CLIENTEMAC1TXUNDERRUN, 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTADDR[0], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTADDR[1], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTADDR[2], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTADDR[3], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTADDR[4], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTADDR[5], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTADDR[6], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTADDR[7], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTADDR[8], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTADDR[9], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTEMAC1SEL, 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTMIIMSEL, 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTOPCODE[0], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTOPCODE[1], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTREQ, 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[0], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[10], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[11], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[12], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[13], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[14], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[15], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[16], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[17], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[18], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[19], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[1], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[20], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[21], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[22], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[23], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[24], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[25], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[26], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[27], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[28], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[29], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[2], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[30], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[31], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[3], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[4], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[5], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[6], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[7], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[8], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge HOSTWRDATA[9], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge PHYEMAC0MDIN, 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, negedge PHYEMAC1MDIN, 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTADDR[0], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTADDR[1], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTADDR[2], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTADDR[3], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTADDR[4], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTADDR[5], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTADDR[6], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTADDR[7], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTADDR[8], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTADDR[9], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTEMAC1SEL, 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTMIIMSEL, 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTOPCODE[0], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTOPCODE[1], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTREQ, 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[0], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[10], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[11], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[12], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[13], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[14], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[15], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[16], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[17], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[18], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[19], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[1], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[20], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[21], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[22], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[23], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[24], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[25], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[26], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[27], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[28], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[29], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[2], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[30], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[31], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[3], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[4], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[5], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[6], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[7], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[8], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge HOSTWRDATA[9], 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge PHYEMAC0MDIN, 0:0:0, 0:0:0);
	$setuphold (posedge HOSTCLK, posedge PHYEMAC1MDIN, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0MCLKIN, negedge PHYEMAC0MDIN, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1MCLKIN, negedge PHYEMAC1MDIN, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0MCLKIN, posedge PHYEMAC0MDIN, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1MCLKIN, posedge PHYEMAC1MDIN, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge CLIENTEMAC0DCMLOCKED, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXBUFERR, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXBUFSTATUS[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXBUFSTATUS[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXCHARISCOMMA, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXCHARISK, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXCHECKINGCRC, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXCLKCORCNT[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXCLKCORCNT[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXCLKCORCNT[2], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXCOMMADET, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXDISPERR, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXLOSSOFSYNC[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXLOSSOFSYNC[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXNOTINTABLE, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0RXRUNDISP, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge PHYEMAC0TXBUFERR, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge TIEEMAC0CONFIGVEC[74], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge TIEEMAC0CONFIGVEC[75], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, negedge TIEEMAC0CONFIGVEC[76], 0:0:0, 0:0:0);
 	$setuphold (posedge PHYEMAC0GTXCLK, negedge TIEEMAC0CONFIGVEC[77], 0:0:0, 0:0:0);
 	$setuphold (posedge PHYEMAC0GTXCLK, negedge TIEEMAC0CONFIGVEC[78], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge CLIENTEMAC0DCMLOCKED, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXBUFERR, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXBUFSTATUS[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXBUFSTATUS[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXCHARISCOMMA, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXCHARISK, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXCHECKINGCRC, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXCLKCORCNT[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXCLKCORCNT[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXCLKCORCNT[2], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXCOMMADET, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXDISPERR, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXLOSSOFSYNC[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXLOSSOFSYNC[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXNOTINTABLE, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0RXRUNDISP, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge PHYEMAC0TXBUFERR, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge TIEEMAC0CONFIGVEC[74], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge TIEEMAC0CONFIGVEC[75], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0GTXCLK, posedge TIEEMAC0CONFIGVEC[76], 0:0:0, 0:0:0);
 	$setuphold (posedge PHYEMAC0GTXCLK, posedge TIEEMAC0CONFIGVEC[77], 0:0:0, 0:0:0);
 	$setuphold (posedge PHYEMAC0GTXCLK, posedge TIEEMAC0CONFIGVEC[78], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, negedge PHYEMAC0COL, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, negedge PHYEMAC0CRS, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, negedge PHYEMAC0RXDV, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, negedge PHYEMAC0RXD[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, negedge PHYEMAC0RXD[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, negedge PHYEMAC0RXD[2], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, negedge PHYEMAC0RXD[3], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, negedge PHYEMAC0RXD[4], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, negedge PHYEMAC0RXD[5], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, negedge PHYEMAC0RXD[6], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, negedge PHYEMAC0RXD[7], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, negedge PHYEMAC0RXER, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, posedge PHYEMAC0COL, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, posedge PHYEMAC0CRS, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, posedge PHYEMAC0RXDV, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, posedge PHYEMAC0RXD[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, posedge PHYEMAC0RXD[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, posedge PHYEMAC0RXD[2], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, posedge PHYEMAC0RXD[3], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, posedge PHYEMAC0RXD[4], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, posedge PHYEMAC0RXD[5], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, posedge PHYEMAC0RXD[6], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, posedge PHYEMAC0RXD[7], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC0RXCLK, posedge PHYEMAC0RXER, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge CLIENTEMAC1DCMLOCKED, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXBUFERR, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXBUFSTATUS[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXBUFSTATUS[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXCHARISCOMMA, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXCHARISK, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXCHECKINGCRC, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXCLKCORCNT[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXCLKCORCNT[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXCLKCORCNT[2], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXCOMMADET, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXDISPERR, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXLOSSOFSYNC[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXLOSSOFSYNC[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXNOTINTABLE, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1RXRUNDISP, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge PHYEMAC1TXBUFERR, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge TIEEMAC1CONFIGVEC[74], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge TIEEMAC1CONFIGVEC[75], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, negedge TIEEMAC1CONFIGVEC[76], 0:0:0, 0:0:0);
 	$setuphold (posedge PHYEMAC1GTXCLK, negedge TIEEMAC1CONFIGVEC[77], 0:0:0, 0:0:0);
 	$setuphold (posedge PHYEMAC1GTXCLK, negedge TIEEMAC1CONFIGVEC[78], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge CLIENTEMAC1DCMLOCKED, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXBUFERR, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXBUFSTATUS[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXBUFSTATUS[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXCHARISCOMMA, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXCHARISK, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXCHECKINGCRC, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXCLKCORCNT[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXCLKCORCNT[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXCLKCORCNT[2], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXCOMMADET, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXDISPERR, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXLOSSOFSYNC[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXLOSSOFSYNC[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXNOTINTABLE, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1RXRUNDISP, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge PHYEMAC1TXBUFERR, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge TIEEMAC1CONFIGVEC[74], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge TIEEMAC1CONFIGVEC[75], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1GTXCLK, posedge TIEEMAC1CONFIGVEC[76], 0:0:0, 0:0:0);
 	$setuphold (posedge PHYEMAC1GTXCLK, posedge TIEEMAC1CONFIGVEC[77], 0:0:0, 0:0:0);
 	$setuphold (posedge PHYEMAC1GTXCLK, posedge TIEEMAC1CONFIGVEC[78], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, negedge PHYEMAC1COL, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, negedge PHYEMAC1CRS, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, negedge PHYEMAC1RXDV, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, negedge PHYEMAC1RXD[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, negedge PHYEMAC1RXD[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, negedge PHYEMAC1RXD[2], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, negedge PHYEMAC1RXD[3], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, negedge PHYEMAC1RXD[4], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, negedge PHYEMAC1RXD[5], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, negedge PHYEMAC1RXD[6], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, negedge PHYEMAC1RXD[7], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, negedge PHYEMAC1RXER, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, posedge PHYEMAC1COL, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, posedge PHYEMAC1CRS, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, posedge PHYEMAC1RXDV, 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, posedge PHYEMAC1RXD[0], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, posedge PHYEMAC1RXD[1], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, posedge PHYEMAC1RXD[2], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, posedge PHYEMAC1RXD[3], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, posedge PHYEMAC1RXD[4], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, posedge PHYEMAC1RXD[5], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, posedge PHYEMAC1RXD[6], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, posedge PHYEMAC1RXD[7], 0:0:0, 0:0:0);
	$setuphold (posedge PHYEMAC1RXCLK, posedge PHYEMAC1RXER, 0:0:0, 0:0:0);
	specparam PATHPULSE$ = 0;
endspecify
endmodule
